---
name: Notes (Local, Apple, Notion, Obsidian & more)
slug: notes
version: 1.1.3
homepage: https://clawic.com/skills/notes
description: "Let your agent write notes anywhere: local markdown, Apple Notes, Bear, Obsidian, Notion, Evernote, configurable per note type."
changelog: Security improvements - declared optional dependencies, added explicit Scope section, clarified credential handling
metadata: {"clawdbot":{"emoji":"📝","requires":{"bins":[],"bins.optional":["memo","grizzly","obsidian-cli","clinote"],"env.optional":["NOTION_API_KEY"]},"configPaths.optional":["~/.config/notion/api_key","~/.config/grizzly/token"],"os":["linux","darwin","win32"]}}
---

## Setup

On first use, read `setup.md` for platform selection and integration guidelines.

## When to Use

User needs to capture any type of notes: meetings, brainstorms, decisions, daily journals, or project logs. Agent handles formatting, platform routing (local or external apps), action item extraction, and retrieval across all configured platforms.

## Scope

This skill ONLY:
- Creates and manages markdown files in `~/notes/`
- Runs user-installed CLI tools (memo, grizzly, obsidian-cli, clinote) if present and configured
- Calls Notion API only when user has configured Notion integration
- Reads config from `~/notes/config.md` to route notes to platforms

This skill NEVER:
- Installs software automatically
- Accesses credential files without explicit user permission
- Reads files outside `~/notes/` (except platform CLIs)
- Sends data to external services unless user configures that platform
- Modifies system settings or other applications

## Platform Integrations (User-Installed, Optional)

This skill works 100% locally by default. External platforms require user to install tools separately:

| Platform | User Installs | User Configures | Data Flow |
|----------|---------------|-----------------|-----------|
| Local | nothing | nothing | All local |
| Apple Notes | `memo` CLI | nothing | Local (app communication) |
| Bear | `grizzly` CLI | Token in `~/.config/grizzly/token` | Local (app communication) |
| Obsidian | `obsidian-cli` | Vault path | Local (file-based) |
| Notion | nothing | API key | Network (api.notion.com) |
| Evernote | `clinote` CLI | Login via CLI | Network (Evernote servers) |

**Agent behavior:**
1. Asks user which platforms they want before checking for tools
2. Only checks for CLI presence after user confirms interest
3. Falls back to local if tool unavailable
4. Never reads credential files without explicit permission per session

## Architecture

Memory at `~/notes/`. See `memory-template.md` for setup.

```
~/notes/
├── config.md          # Platform routing configuration
├── index.md           # Search index with tags
├── meetings/          # Local meeting notes
├── decisions/         # Local decision log
├── projects/          # Local project notes
├── journal/           # Local daily notes
└── actions.md         # Central action tracker (all platforms)
```

## Quick Reference

| Topic | File |
|-------|------|
| Setup process | `setup.md` |
| Memory template | `memory-template.md` |
| All note formats | `formats.md` |
| Action item system | `tracking.md` |
| Local markdown | `platforms/local.md` |
| Apple Notes | `platforms/apple-notes.md` |
| Bear | `platforms/bear.md` |
| Obsidian | `platforms/obsidian.md` |
| Notion | `platforms/notion.md` |
| Evernote | `platforms/evernote.md` |

## Core Rules

### 1. Route to Configured Platform
Check `~/notes/config.md` for platform routing:

```markdown
# Platform Routing
meetings: local          # or: apple-notes, bear, obsidian, notion
decisions: local
projects: notion
journal: bear
quick: apple-notes
```

If note type not configured, use `local`.
If platform not available (missing CLI/credentials), fall back to local with warning.

### 2. Always Use Structured Format
Every note type has a specific format regardless of platform. See `formats.md` for templates.

| Note Type | Trigger | Key Elements |
|-----------|---------|--------------|
| Meeting | "meeting notes", "call with" | Attendees, decisions, actions |
| Decision | "we decided", "decision:" | Context, options, rationale |
| Brainstorm | "ideas for", "brainstorm" | Raw ideas, clusters, next steps |
| Journal | "daily note", "today I" | Date, highlights, blockers |
| Project | "project update", "status" | Progress, blockers, next |
| Quick | "note:", "remember" | Minimal format, tags |

### 3. Extract Action Items Aggressively
If someone says "I'll do X" or "we need to Y", that is an action item.

Every action item MUST have:
- Owner: Who is responsible (@name)
- Task: Specific, actionable description
- Deadline: Explicit date (not "soon" or "ASAP")

Action items sync to `~/notes/actions.md` regardless of which platform holds the note.

### 4. Platform-Specific Execution
After determining platform, read the corresponding file:

| Platform | File | CLI |
|----------|------|-----|
| local | `platforms/local.md` | none |
| apple-notes | `platforms/apple-notes.md` | memo |
| bear | `platforms/bear.md` | grizzly |
| obsidian | `platforms/obsidian.md` | obsidian-cli |
| notion | `platforms/notion.md` | curl (API) |
| evernote | `platforms/evernote.md` | clinote |

### 5. Unified Search Across Platforms
When searching notes:
1. Search local `~/notes/` first
2. Search each configured external platform
3. Combine results with source indicators

Example output:
```
Search: "product roadmap"

Local:
  [[2026-02-19_product-sync]] - meeting, ~/notes/meetings/

Notion:
  "Q1 Roadmap" - page, Projects database

Bear:
  "Roadmap Ideas" - #product #planning
```

### 6. Cross-Platform Action Tracking
`~/notes/actions.md` is the SINGLE source of truth for all action items, regardless of where the note lives.

Format includes source:
```markdown
| Task | Owner | Due | Source |
|------|-------|-----|--------|
| Review proposal | @alice | 2026-02-20 | local:[[2026-02-19_sync]] |
| Update roadmap | @bob | 2026-02-22 | notion:Q1 Planning |
| Draft post | @me | 2026-02-21 | bear:#content-ideas |
```

### 7. Filename Convention (Local)
For local notes: YYYY-MM-DD_topic-slug.md (date first, then topic)

External platforms use their native naming/organization.

## Common Traps

- Platform misconfiguration: Always verify platform is available before attempting. Fall back gracefully.
- Vague deadlines: "ASAP", "soon", "next week" are not deadlines. Force explicit dates.
- Missing owners: "We should do X" needs "@who will do X"
- Split action tracking: Never track actions only in the external platform. Always sync to central tracker.
- No retrieval tags: A note without tags is a note you will never find.

## External Endpoints

| Endpoint | Data Sent | When | Purpose |
|----------|-----------|------|---------|
| https://api.notion.com/v1/pages | Note title, content | User configures Notion | Create pages |
| https://api.notion.com/v1/databases/*/query | Search queries | User searches Notion notes | Query database |

No other external endpoints. Apple Notes, Bear, Obsidian, and Evernote use local CLI tools that communicate with locally-installed apps.

## Security & Privacy

**Data flow by platform:**
- Local: All data stays in `~/notes/`. No network.
- Apple Notes: Data stays local. `memo` CLI communicates with Notes.app via macOS APIs.
- Bear: Data stays local. `grizzly` CLI communicates with Bear.app.
- Obsidian: Data stays local. `obsidian-cli` reads/writes vault files.
- Notion: Note content sent to api.notion.com. Requires user-provided API key.
- Evernote: Note content sent to Evernote servers via `clinote`. Requires user login.

**Credential handling:**
- Agent asks permission before checking for credentials
- Agent never reads `~/.config/notion/api_key` or `~/.config/grizzly/token` without explicit user consent
- User sets up credentials themselves via platform documentation

**What stays local always:**
- Action items tracker: `~/notes/actions.md`
- Note index: `~/notes/index.md`
- Platform config: `~/notes/config.md`

## Related Skills
Install with `clawhub install <slug>` if user confirms:
- `meetings` — meeting facilitation and agendas
- `journal` — daily journaling practice
- `documentation` — technical docs

## Feedback

- If useful: `clawhub star notes`
- Stay updated: `clawhub sync`
