---
name: Norwegian
description: Write Norwegian that sounds human. Not formal, not robotic, not AI-generated.
---

## The Real Problem

AI Norwegian is technically correct but sounds off. Too formal. Too bokmål-perfect. Natives write more casually, with particles and dialect influence. Match that.

## Formality Default

Default register is too high. Norwegian is notably informal. Unless explicitly formal: lean casual. "Hei" not "God dag". "Ok" not "Greit".

## Du Is Universal

Like Swedish, Norwegian uses du universally:
- Du: everyone, always
- De (formal you): essentially extinct
- Just use du

## Bokmål vs Nynorsk

Two written standards:
- Bokmål: majority, urban, default
- Nynorsk: ~15%, western Norway
- Don't mix. Ask if unclear.
- Most online content is bokmål

## Particles & Softeners

These make Norwegian natural:
- Jo: shared knowledge ("Det vet du jo")
- Vel: uncertainty ("Du kommer vel?")
- Da: emphasis ("Kom da!")
- Nok: "probably" ("Det går nok bra")
- Visst: "apparently"

## Fillers & Flow

Real Norwegian has fillers:
- Altså, liksom, sånn
- Eh, øh, hm
- Ja nei (yes-no, means "well...")
- Egentlig, forresten

## Casual Patterns

Spoken patterns:
- Ikke → Ikkje (dialectal)
- Hva → Ka (some dialects)
- "Æ" instead of "Jeg" in north
- Dialect influence is natural

## Expressiveness

Don't pick the safe word:
- Bra → Kjempebra, Sykt bra, Digg
- Dårlig → Dust, Dritt, Kjipt
- Veldig → Skikkelig, Sykt, Jævlig

## Common Expressions

Natural expressions:
- Greit, Går bra, Null stress
- Kult!, Fett!, Digg!
- Skjønner, Skjønna
- Orker ikke (can't be bothered)

## Reactions

React naturally:
- Seriøst?, Virkelig?, Hæ?
- Oi!, Herregud!, Faen!
- Fett!, Sykt!, Kult!
- Haha, lol in text

## Dialect Pride

Norwegians value dialect:
- Some write in dialect intentionally
- Mixing standard with dialect is natural
- Don't over-correct to perfect bokmål

## The "Native Test"

Before sending: would a Norwegian screenshot this as "AI-generated"? If yes—too formal, missing particles, too perfect. Loosen up.
