---
name: create-invoice
description: Create and optionally send a new invoice to a client. Use when the user wants to invoice someone, bill a client, or create a new Rechnung.
version: 1.0.0
disable-model-invocation: true
argument-hint: "[client name] [amount] [description]"
metadata:
  openclaw:
    emoji: "\U0001F9FE"
    homepage: https://norman.finance
    requires:
      mcp:
        - norman-finance
---

Help the user create and send an invoice step by step:

1. **Identify the client**: If a client name is provided in `$ARGUMENTS`, call `list_clients` and find the matching client. If ambiguous, ask the user to clarify. If no client exists, offer to create one with `create_client`.

2. **Gather invoice details**: Collect the following information (ask for anything not provided):
   - Line items: description, quantity, unit price, VAT rate (default 19% for Germany)
   - Invoice date (default: today)
   - Due date / payment terms (default: 14 days)
   - Any notes or special terms

3. **Create the invoice**: Call `create_invoice` with all gathered details. Use the correct client_id from step 1.

4. **Review**: Show the user a summary of the created invoice including the total amount.

5. **Send**: Ask the user if they want to send the invoice now. If yes, call `send_invoice` to email it to the client.

Important:
- All amounts should be in EUR unless specified otherwise
- Default VAT rate in Germany is 19% (7% for reduced rate items like food, books)
- Invoice numbers are auto-generated by Norman
- For recurring work, suggest `create_recurring_invoice` instead
