# RBM Framework Reference

## 1. Logic Model Levels

| Level | What it means | Typical examples |
| --- | --- | --- |
| Inputs | Resources invested | Budget, staff, partners, equipment, curriculum |
| Activities | What the program does | Training, coaching, outreach, service delivery |
| Outputs | Direct deliverables | Number trained, sessions held, kits distributed |
| Outcomes | Short/medium-term changes | Skills gained, behavior change, service uptake |
| Impact | Long-term change | Reduced poverty, better health, stronger resilience |

Use this rule to avoid category drift:
- If it is delivered by the program, classify as output.
- If it is a change in people/systems, classify as outcome or impact.

## 2. Outcome Indicator Template

For each outcome, specify 3-5 indicators with this structure:

| Field | What to provide |
| --- | --- |
| Indicator name | Short and specific |
| Definition | Exact interpretation of the metric |
| Formula | Numerator/denominator or computation logic |
| Baseline | Starting value and date |
| Target | Intended value and date |
| Frequency | Monthly, quarterly, semi-annual, annual |
| Source | Survey, MIS, admin records, assessment |
| Disaggregation | Sex, age, location, disability, other relevant factors |
| Owner | Role responsible for data quality and reporting |

## 3. SMART Quality Check

Before finalizing indicators, check:
- Specific: Avoid broad terms such as "improved significantly."
- Measurable: Ensure repeatable data collection method exists.
- Achievable: Match target level to context and capacity.
- Relevant: Confirm direct link to stated outcome.
- Time-bound: Set clear measurement period and deadline.

## 4. Common Sector Mapping

Use these as starting points, then tailor to user context:

| Program type | Common outcome focus | Typical SDG links |
| --- | --- | --- |
| Youth employment | Job placement, retention, income growth | SDG 8.6, SDG 1.2 |
| Girls education | Enrollment, retention, completion, literacy | SDG 4.1, SDG 5.1 |
| Health access | Service uptake, treatment adherence, outcomes | SDG 3.8 |
| Water and sanitation | Access, reliability, disease reduction | SDG 6.1, SDG 6.2 |
| Agriculture/livelihoods | Productivity, food security, resilience | SDG 2.3, SDG 13.1 |

## 5. Data Collection Cadence (Default)

Use this cadence unless the user specifies another:
- Baseline: Before implementation starts
- Routine monitoring: Monthly or quarterly
- Midline: Midpoint for multi-year programs
- Endline: Final project period
- Follow-up: 3-6-12 months after key interventions (when outcomes depend on adoption/retention)

## 6. Worked Example (Condensed)

Program: Rural youth employment training, 3-year horizon

Inputs:
- USD 150,000 budget
- 3 trainers
- Training center and equipment
- Employer network partnerships

Activities:
- 12-week technical training
- Soft-skills and job-readiness workshops
- Placement support and mentoring

Outputs:
- 200 participants complete training
- 150 CVs and interview preparation packages
- 80 employer interviews facilitated

Outcomes:
- At least 70 percent of graduates employed or self-employed within 6 months
- Median income increases by at least 40 percent from baseline by month 12
- At least 80 percent of employers rate graduates as job-ready

Impact:
- Meaningful reduction in youth unemployment across target communities by year 3

Sample indicators for outcome "employed or self-employed within 6 months":
- Employment rate of graduates at 6 months (%; survey + admin verification)
- Retention rate at 12 months (%; follow-up survey)
- Share of employed graduates using trained skills in role (%; follow-up survey)
