---
name: nonprofit-rbm-logic-model
description: Build donor-ready Results-Based Management (RBM) logic models for nonprofit and non-governmental organization (NGO) programs with a 5-level results chain, Theory of Change, Specific-Measurable-Achievable-Relevant-Time-bound (SMART) outcome indicators, Sustainable Development Goals (SDG) alignment, and practical monitoring plans for grant design, implementation, and reporting aligned with United States Agency for International Development (USAID), United Nations (UN), and European Union (EU) requirements.
---

# Nonprofit Results-Based Management (RBM) Logic Model

## Goal

Produce a complete, donor-ready Results-Based Management (RBM) logic model that clearly links resources to long-term change and includes measurable indicators and monitoring guidance.

## Workflow

1. Gather core context before drafting:
- Program problem and intervention summary
- Target population and inclusion priorities
- Geography and implementation scope
- Time horizon (for example, 1 year outcomes vs 3-5 year impact)
- Donor/reporting constraints (United States Agency for International Development (USAID), United Nations (UN), European Union (EU), internal template)
- Baseline availability and data constraints

2. Ask up to five high-leverage clarifying questions when critical context is missing. If details remain unknown, proceed with explicit assumptions.

3. Build a five-level logic model:
- Inputs
- Activities
- Outputs
- Outcomes (short/medium term changes)
- Impact (long-term societal/system change)

4. Keep causal logic explicit and testable:
- Avoid listing activities as outcomes
- Avoid describing deliverables as impact
- Use concrete, time-bound outcome statements where possible

5. Define indicators for each outcome:
- Provide 3-5 Specific-Measurable-Achievable-Relevant-Time-bound (SMART) indicators per outcome
- Include definition/formula, baseline, target, frequency, and data source
- Include disaggregation guidance (for example sex, age, location) when relevant

6. Map outcomes and impact to relevant Sustainable Development Goals (SDG) goals and targets only when there is a defensible link.

7. Propose a practical data collection plan:
- Baseline and endline timing
- Routine monitoring frequency
- Follow-up windows (for example 3/6/12 months)
- Data quality checks and accountability owner

8. Return output in the required format.

## Output Format

1. Theory of Change (if/then statement plus causal pathway and key assumptions)
2. Executive Summary (2-3 sentences)
3. Logic Model Table (Inputs to Impact)
4. Outcome Indicators (group by outcome)
5. Sustainable Development Goals (SDG) Alignment (goal and target references)
6. Data Collection Plan (method, frequency, owner)
7. Assumptions and Risks (recommended when uncertainty exists)

## Quality Rules

- Prefer numeric targets and time bounds over vague language.
- Distinguish outputs from outcomes:
  - Outputs are products/services delivered.
  - Outcomes are changes in behavior, conditions, or systems.
- Keep impact long-term unless user requests a shorter horizon.
- State assumptions explicitly for any inferred values.
- Flag missing baseline data and suggest how to collect it.

## Reference Usage

Use `references/rbm-framework.md` when you need:
- Indicator templates
- Sector-specific indicator ideas
- Sustainable Development Goals (SDG) mapping shortcuts
- A complete worked example
