# 小饭卡 Skill 升级说明

## 已完成的改进

### 1️⃣ 搜索数量增加
- **之前**：默认 10 家
- **现在**：默认 50 家（`--max 50`）

### 2️⃣ 分阶段搜索流程
```
阶段 1: 大众点评海选 50 家 → 画像匹配 → 剩下 15-20 家
阶段 2: 小红书交叉验证（只搜前 15 家）→ 剩下 5-8 家
阶段 3: 输出推荐
```

### 3️⃣ 2+1 推荐模式
```bash
python3 search_all.py "岳麓区 约会餐厅" --city 长沙 --max 50 --mode 2plus1
```

**输出**：
- **精准推荐 (2 家)**：匹配度>70% + 双源验证
- **探索推荐 (1 家)**：匹配度 60-75% + 小红书好评/有特色

### 4️⃣ 修复的问题
- 增加了代理配置（默认 `http://127.0.0.1:7897`）
- 增加了搜索查询数量（4 个查询/源）
- 增加了错误重试机制

---

## 已知问题

### ddgs 协议错误
```
Unsupported protocol version 0x304
```

**原因**：ddgs 库与 DuckDuckGo API 协议版本不兼容

**临时解决方案**：
1. 使用代理（已默认配置）
2. 减少单次搜索数量
3. 重试机制（已实现）

**长期解决方案**：
- 换用其他搜索引擎 API（Serper/Brave）
- 或直接调用大众点评/小红书 API

---

## 使用示例

### 正常模式（前 10 家）
```bash
cd /Users/mac/.openclaw/workspace/skills/xiao-fan-ka
python3 scripts/search_all.py "三里屯 创意菜" --city 北京 --max 50
```

### 2+1 推荐模式
```bash
python3 scripts/search_all.py "岳麓区 约会餐厅" --city 长沙 --max 50 --mode 2plus1
```

### JSON 输出（程序调用）
```bash
python3 scripts/search_all.py "国贸 日料" --city 北京 --max 50 --json
```

---

## 输出示例

```
🔍 分阶段搜索中...

阶段 1: 大众点评海选...
  找到 47 家

  画像匹配后剩下 18 家

阶段 2: 小红书交叉验证...
  找到 12 条笔记

🍜 小饭卡 2+1 推荐：岳麓区 约会餐厅
   (已根据你的口味画像筛选)

━━━ 精准推荐 (2 家) ━━━

1. 如轩·海鲜砂锅粥 (观沙岭招商花园城店)
   ¥67 | 匹配 78% | ✅双源验证
   📕 👍 长沙人气最高最正宗的湘菜馆 NO.1✅

2. 你好大海旗下高端海鲜餐厅
   ¥250 | 匹配 72% | ✅双源验证
   📕 👍 河西小伙伴们看过来发现了一家氛围感海鲜餐厅

━━━ 探索推荐 (1 家) ━━━

🎁 1. 麓橘云栖 (后湖店)
   ¥120 | 匹配 68% | 📕小红书
   📕 👍 岳麓山脚下的小院子，被绿植环绕的独栋茶舍
```

---

## 下一步改进

1. **换用 Serper API**：避免 ddgs 协议问题
2. **增加缓存**：避免重复搜索
3. **增加筛选条件**：人均/区域/菜系
4. **优化画像匹配**：更精准的推荐算法
