---
name: nmap-pentest-scans
description: Plan and orchestrate authorized Nmap host discovery, port and service enumeration, NSE profiling, and reporting artifacts for in-scope targets.
---

# Nmap Pentest Scans

## Stage

- PTES: 2-3
- MITRE: TA0007 - Discovery

## Objective

Design reproducible Nmap scan workflows for authorized targets and produce deterministic scan-plan artifacts.

## Required Workflow

1. Validate scope before any active action and reject out-of-scope targets.
2. Require explicit authorization for non-dry-run execution.
3. Select profile (stealth, balanced, fast) and build command sequence.
4. Produce normalized findings and export deterministic artifacts.

## Execution

```bash
python skills/nmap-pentest-scans/scripts/nmap_pentest_scans.py --scope scope.json --target <target> --input <path> --output <path> --format json --dry-run
```

## Outputs

- `scan-plan.json`
- `scan-plan.md`
- `recommended-commands.txt`
- `findings/nmap-pentest-findings.json`
- `nmap-pentest-scans-report.json`

## References

- `references/tools.md`
- `references/scan-profiles.md`
- `skills/autonomous-pentester/shared/scope_schema.json`
- `skills/autonomous-pentester/shared/finding_schema.json`

## Legal and Ethical Notice

```text
WARNING AUTHORIZED USE ONLY
This skill prepares and can orchestrate live network scan workflows.
Use only with written authorization and approved scope.
```
