---
name: Nimrobo
description: Use the Nimrobo CLI for voice screening and matching network operations.
---

# Nimrobo CLI Skill

This skill enables you to use the Nimrobo CLI for voice screening and matching network operations.

## Overview

Nimrobo CLI provides two command platforms:

1. **Voice Commands** (`nimrobo voice`) - Voice-first AI platform for running interviews, screening, and diagnostic conversations via shareable voice-links
2. **Net Commands** (`nimrobo net`) - Matching network for organizations, job posts, applications, and messaging

Both platforms share the same authentication system.

## Key Concepts

### Input Methods

Commands support multiple input methods (in priority order):
1. **CLI Flags** - Direct options like `--name "Value"`
2. **JSON Files** - Use `-f ./data.json` for complex inputs
3. **Stdin** - Use `--stdin` to pipe JSON input
4. **Interactive Mode** - Prompts when flags aren't provided

### Context System (Net Commands)

Net commands support a context system to avoid repeating IDs:

```bash
# Set context
nimrobo net orgs use org_abc123
nimrobo net posts use post_xyz789

# Use "current" to reference stored context
nimrobo net orgs get current
nimrobo net posts applications current

# View/clear context
nimrobo net context show
nimrobo net context clear
```

### Pagination

List commands support `--limit` and `--skip` for pagination:

```bash
nimrobo net posts list --limit 20 --skip 40  # Page 3
```

### JSON Output

Add `--json` to any command for machine-readable output:

```bash
nimrobo net posts list --json
```

## Documentation Files

This skill includes the following documentation files for detailed reference:

| File | Description |
|------|-------------|
| `installation.md` | **Start Here**: Installation, login, and onboarding steps |
| `commands.md` | Quick reference table of all commands |
| `voice-commands.md` | Detailed Voice platform commands with examples |
| `net-commands.md` | Detailed Net platform commands with examples |
| `workflow.md` | Common workflow patterns and examples |

## Common Workflows

### Voice: Run an Interview

```bash
# Create project and generate interview links
nimrobo voice projects create -f interview.json
nimrobo voice projects use proj_abc123
nimrobo voice links create -p default -l "Alice,Bob,Charlie" -e 1_week

# After interviews, get results
nimrobo voice sessions evaluation sess_xyz -t project -p default
nimrobo voice sessions transcript sess_xyz -t project -p default --json
```

### Net: Post a Job

```bash
# Create org and post
nimrobo net orgs create --name "Acme Corp" --use
nimrobo net posts create --title "Senior Engineer" --short-content "Join our team!" --expires "2024-06-01" --org current --use

# Review applications
nimrobo net posts applications current --status pending
nimrobo net applications accept app_123
```

### Net: Apply for Jobs

```bash
# Search and apply
nimrobo net posts list --query "engineer" --filter '{"remote": "remote", "salary_min": 100000}'
nimrobo net posts apply post_xyz --note "I'm excited about this role..."

# Track applications
nimrobo net my applications --status pending
```

## Tips for Automation

1. **Use `--json` flag** for parsing output programmatically
2. **Set context** with `use` commands to avoid repeating IDs
3. **Use JSON files** (`-f`) for complex create/update operations
4. **Check `my summary`** for a quick overview of pending actions
5. **Batch operations** are available for applications (`batch-action`)

## Exit Codes

| Code | Description |
|------|-------------|
| 0 | Success |
| 1 | Error |

## Getting Help

See [installation.md](installation.md) for setup instructions.

```bash
nimrobo --help              # List all commands
nimrobo voice --help        # Voice platform help
nimrobo net --help          # Net platform help
nimrobo <command> --help    # Help for specific command
```

# Onboard (set up profile and org from JSON). run only if the user says to onboard. and follow the instructions as per the response and ask user questions to fill onboarding.
nimrobo onboard