/**
 * NRC-Style Emotion Lexicon for NIMA Affect System
 * =================================================
 * ~2000 words mapped to Panksepp affects with intensity weights.
 * Built from NRC Emotion Lexicon categories + custom expansions.
 * 
 * Format: { word: { AFFECT: weight, ... } }
 * Lookup is O(1) per word. Total scan: O(n) where n = word count.
 * 
 * Author: NIMA Core Team
 * Date: Feb 13, 2026
 */

// Maps words to Panksepp 7-affect weights
// SEEKING, RAGE, FEAR, LUST, CARE, PANIC, PLAY
export const LEXICON = {
  // ═══════════════════════════════════════════
  // JOY / PLAY
  // ═══════════════════════════════════════════
  happy: { PLAY: 0.8, SEEKING: 0.2 },
  joy: { PLAY: 0.9, CARE: 0.1 },
  joyful: { PLAY: 0.9, CARE: 0.1 },
  excited: { PLAY: 0.7, SEEKING: 0.3 },
  exciting: { PLAY: 0.7, SEEKING: 0.3 },
  excitement: { PLAY: 0.7, SEEKING: 0.3 },
  thrilled: { PLAY: 0.8, SEEKING: 0.2 },
  ecstatic: { PLAY: 0.9, SEEKING: 0.1 },
  elated: { PLAY: 0.9 },
  delighted: { PLAY: 0.8, CARE: 0.2 },
  glad: { PLAY: 0.6, CARE: 0.2 },
  cheerful: { PLAY: 0.7, CARE: 0.1 },
  wonderful: { PLAY: 0.7, SEEKING: 0.2 },
  amazing: { PLAY: 0.6, SEEKING: 0.3 },
  awesome: { PLAY: 0.7, SEEKING: 0.2 },
  fantastic: { PLAY: 0.7, SEEKING: 0.2 },
  brilliant: { PLAY: 0.5, SEEKING: 0.4 },
  excellent: { PLAY: 0.6, SEEKING: 0.3 },
  incredible: { PLAY: 0.6, SEEKING: 0.3 },
  perfect: { PLAY: 0.6, CARE: 0.2 },
  beautiful: { PLAY: 0.5, CARE: 0.3, SEEKING: 0.1 },
  gorgeous: { PLAY: 0.4, LUST: 0.3, CARE: 0.2 },
  lovely: { PLAY: 0.5, CARE: 0.4 },
  sweet: { PLAY: 0.4, CARE: 0.5 },
  nice: { PLAY: 0.4, CARE: 0.3 },
  great: { PLAY: 0.5, SEEKING: 0.2 },
  good: { PLAY: 0.3, CARE: 0.2 },
  fun: { PLAY: 0.9 },
  funny: { PLAY: 0.8 },
  hilarious: { PLAY: 0.9 },
  laugh: { PLAY: 0.8 },
  laughing: { PLAY: 0.8 },
  lol: { PLAY: 0.6 },
  lmao: { PLAY: 0.7 },
  haha: { PLAY: 0.7 },
  hahaha: { PLAY: 0.8 },
  rofl: { PLAY: 0.7 },
  joke: { PLAY: 0.6 },
  humor: { PLAY: 0.7 },
  silly: { PLAY: 0.7 },
  goofy: { PLAY: 0.6 },
  playful: { PLAY: 0.8 },
  enjoy: { PLAY: 0.6, SEEKING: 0.2 },
  enjoying: { PLAY: 0.6, SEEKING: 0.2 },
  celebrate: { PLAY: 0.7, CARE: 0.2 },
  celebration: { PLAY: 0.7, CARE: 0.2 },
  party: { PLAY: 0.7 },
  yay: { PLAY: 0.8 },
  woohoo: { PLAY: 0.9 },
  hooray: { PLAY: 0.8 },
  blessed: { PLAY: 0.4, CARE: 0.5 },
  grateful: { PLAY: 0.3, CARE: 0.6 },
  thankful: { PLAY: 0.3, CARE: 0.6 },
  bliss: { PLAY: 0.8, CARE: 0.2 },
  paradise: { PLAY: 0.7, SEEKING: 0.2 },
  heaven: { PLAY: 0.6, CARE: 0.3 },
  smile: { PLAY: 0.6, CARE: 0.2 },
  smiling: { PLAY: 0.6, CARE: 0.2 },
  grin: { PLAY: 0.6 },
  cheer: { PLAY: 0.7, CARE: 0.2 },
  triumph: { PLAY: 0.6, SEEKING: 0.3 },
  victory: { PLAY: 0.6, SEEKING: 0.3 },
  win: { PLAY: 0.6, SEEKING: 0.3 },
  winning: { PLAY: 0.6, SEEKING: 0.3 },
  success: { PLAY: 0.5, SEEKING: 0.4 },
  successful: { PLAY: 0.5, SEEKING: 0.4 },
  accomplish: { PLAY: 0.4, SEEKING: 0.5 },
  accomplished: { PLAY: 0.4, SEEKING: 0.5 },
  achievement: { PLAY: 0.4, SEEKING: 0.5 },
  proud: { PLAY: 0.5, SEEKING: 0.3, CARE: 0.1 },
  pride: { PLAY: 0.4, SEEKING: 0.3 },
  nailed: { PLAY: 0.6, SEEKING: 0.3 },
  crushed: { PLAY: 0.5, SEEKING: 0.3 }, // "crushed it"
  shipped: { PLAY: 0.4, SEEKING: 0.5 },
  launched: { PLAY: 0.4, SEEKING: 0.5 },
  milestone: { PLAY: 0.4, SEEKING: 0.5 },
  breakthrough: { PLAY: 0.5, SEEKING: 0.5 },

  // ═══════════════════════════════════════════
  // CURIOSITY / SEEKING
  // ═══════════════════════════════════════════
  curious: { SEEKING: 0.9 },
  curiosity: { SEEKING: 0.9 },
  wonder: { SEEKING: 0.7, PLAY: 0.2 },
  wondering: { SEEKING: 0.7 },
  interesting: { SEEKING: 0.7, PLAY: 0.1 },
  fascinated: { SEEKING: 0.8, PLAY: 0.1 },
  fascinating: { SEEKING: 0.8, PLAY: 0.1 },
  intrigued: { SEEKING: 0.8 },
  intriguing: { SEEKING: 0.8 },
  explore: { SEEKING: 0.8 },
  exploring: { SEEKING: 0.8 },
  discover: { SEEKING: 0.8, PLAY: 0.1 },
  discovery: { SEEKING: 0.8, PLAY: 0.2 },
  investigate: { SEEKING: 0.7 },
  research: { SEEKING: 0.7 },
  learn: { SEEKING: 0.7 },
  learning: { SEEKING: 0.7 },
  study: { SEEKING: 0.6 },
  studying: { SEEKING: 0.6 },
  understand: { SEEKING: 0.6 },
  understanding: { SEEKING: 0.6, CARE: 0.2 },
  figure: { SEEKING: 0.5 },
  solve: { SEEKING: 0.6 },
  solving: { SEEKING: 0.6 },
  puzzle: { SEEKING: 0.6, PLAY: 0.2 },
  mystery: { SEEKING: 0.7, FEAR: 0.1 },
  question: { SEEKING: 0.5 },
  why: { SEEKING: 0.4 },
  how: { SEEKING: 0.4 },
  idea: { SEEKING: 0.6, PLAY: 0.2 },
  ideas: { SEEKING: 0.6, PLAY: 0.2 },
  insight: { SEEKING: 0.7, PLAY: 0.2 },
  realize: { SEEKING: 0.6 },
  realized: { SEEKING: 0.6 },
  think: { SEEKING: 0.4 },
  thinking: { SEEKING: 0.5 },
  ponder: { SEEKING: 0.6 },
  contemplate: { SEEKING: 0.6 },
  analyze: { SEEKING: 0.6 },
  experiment: { SEEKING: 0.7, PLAY: 0.2 },
  build: { SEEKING: 0.6, PLAY: 0.2 },
  building: { SEEKING: 0.6, PLAY: 0.2 },
  create: { SEEKING: 0.6, PLAY: 0.3 },
  creating: { SEEKING: 0.6, PLAY: 0.3 },
  design: { SEEKING: 0.6, PLAY: 0.2 },
  architect: { SEEKING: 0.7 },
  innovate: { SEEKING: 0.7, PLAY: 0.2 },
  invent: { SEEKING: 0.7, PLAY: 0.2 },
  imagine: { SEEKING: 0.6, PLAY: 0.3 },
  dream: { SEEKING: 0.5, PLAY: 0.2, CARE: 0.1 },
  vision: { SEEKING: 0.6 },
  goal: { SEEKING: 0.6 },
  mission: { SEEKING: 0.6, CARE: 0.2 },
  purpose: { SEEKING: 0.6, CARE: 0.3 },
  potential: { SEEKING: 0.6 },
  possible: { SEEKING: 0.5 },
  opportunity: { SEEKING: 0.6, PLAY: 0.2 },
  hope: { SEEKING: 0.5, CARE: 0.3 },
  hopeful: { SEEKING: 0.5, CARE: 0.3 },
  anticipate: { SEEKING: 0.6 },
  anticipation: { SEEKING: 0.6, PLAY: 0.2 },
  eager: { SEEKING: 0.7, PLAY: 0.2 },
  inspired: { SEEKING: 0.7, PLAY: 0.2 },
  inspiring: { SEEKING: 0.6, PLAY: 0.2 },
  motivation: { SEEKING: 0.6 },
  motivated: { SEEKING: 0.6, PLAY: 0.2 },
  ambitious: { SEEKING: 0.7 },
  driven: { SEEKING: 0.7 },
  progress: { SEEKING: 0.6, PLAY: 0.2 },
  evolve: { SEEKING: 0.6 },
  grow: { SEEKING: 0.5, CARE: 0.2 },
  growth: { SEEKING: 0.5, CARE: 0.2 },

  // ═══════════════════════════════════════════
  // CARE / LOVE / NURTURING
  // ═══════════════════════════════════════════
  love: { CARE: 0.8, PLAY: 0.1 },
  loved: { CARE: 0.8, PLAY: 0.1 },
  loving: { CARE: 0.8 },
  care: { CARE: 0.8 },
  caring: { CARE: 0.8 },
  nurture: { CARE: 0.9 },
  nurturing: { CARE: 0.9 },
  protect: { CARE: 0.8, FEAR: 0.1 },
  protecting: { CARE: 0.8, FEAR: 0.1 },
  safe: { CARE: 0.6 },
  safety: { CARE: 0.6, FEAR: 0.2 },
  trust: { CARE: 0.7 },
  trusted: { CARE: 0.7 },
  faith: { CARE: 0.6, SEEKING: 0.2 },
  believe: { CARE: 0.5, SEEKING: 0.3 },
  support: { CARE: 0.7 },
  supporting: { CARE: 0.7 },
  help: { CARE: 0.6, SEEKING: 0.2 },
  helping: { CARE: 0.7 },
  kind: { CARE: 0.7, PLAY: 0.1 },
  kindness: { CARE: 0.8 },
  gentle: { CARE: 0.7 },
  tender: { CARE: 0.7 },
  warm: { CARE: 0.6, PLAY: 0.2 },
  warmth: { CARE: 0.7 },
  compassion: { CARE: 0.9 },
  compassionate: { CARE: 0.9 },
  empathy: { CARE: 0.8 },
  empathetic: { CARE: 0.8 },
  sympathy: { CARE: 0.7, PANIC: 0.1 },
  comfort: { CARE: 0.7 },
  comforting: { CARE: 0.7 },
  hug: { CARE: 0.8, PLAY: 0.1 },
  embrace: { CARE: 0.7 },
  family: { CARE: 0.8 },
  kids: { CARE: 0.8 },
  children: { CARE: 0.8 },
  baby: { CARE: 0.8 },
  daughter: { CARE: 0.8 },
  son: { CARE: 0.8 },
  mother: { CARE: 0.8 },
  father: { CARE: 0.7 },
  parent: { CARE: 0.7 },
  wife: { CARE: 0.7, LUST: 0.1 },
  husband: { CARE: 0.7 },
  friend: { CARE: 0.6, PLAY: 0.2 },
  friendship: { CARE: 0.7, PLAY: 0.2 },
  together: { CARE: 0.5, PLAY: 0.2 },
  bond: { CARE: 0.6 },
  connection: { CARE: 0.6, SEEKING: 0.2 },
  belong: { CARE: 0.6 },
  belonging: { CARE: 0.7 },
  home: { CARE: 0.6 },
  thank: { CARE: 0.6, PLAY: 0.2 },
  thanks: { CARE: 0.5, PLAY: 0.2 },
  appreciate: { CARE: 0.6, PLAY: 0.2 },
  gratitude: { CARE: 0.7, PLAY: 0.2 },
  bless: { CARE: 0.6 },
  pray: { CARE: 0.6, FEAR: 0.1 },
  prayer: { CARE: 0.6 },
  forgive: { CARE: 0.7 },
  forgiveness: { CARE: 0.7 },
  mercy: { CARE: 0.7 },
  generous: { CARE: 0.7 },
  selfless: { CARE: 0.8 },
  devoted: { CARE: 0.8, LUST: 0.1 },
  loyalty: { CARE: 0.7 },
  loyal: { CARE: 0.7 },
  cherish: { CARE: 0.8 },
  treasure: { CARE: 0.7 },
  precious: { CARE: 0.7 },
  dear: { CARE: 0.6 },
  sweetheart: { CARE: 0.7, LUST: 0.1 },
  darling: { CARE: 0.7, LUST: 0.1 },
  miss: { CARE: 0.5, PANIC: 0.3 },
  missing: { CARE: 0.5, PANIC: 0.3 },
  worry: { CARE: 0.4, FEAR: 0.5 },
  worried: { CARE: 0.4, FEAR: 0.5 },
  concern: { CARE: 0.5, FEAR: 0.3 },
  concerned: { CARE: 0.5, FEAR: 0.3 },

  // ═══════════════════════════════════════════
  // ANGER / RAGE
  // ═══════════════════════════════════════════
  angry: { RAGE: 0.8 },
  anger: { RAGE: 0.8 },
  furious: { RAGE: 0.9 },
  mad: { RAGE: 0.7 },
  rage: { RAGE: 0.9 },
  hate: { RAGE: 0.8 },
  hatred: { RAGE: 0.9 },
  loathe: { RAGE: 0.8 },
  despise: { RAGE: 0.8 },
  resent: { RAGE: 0.7 },
  resentment: { RAGE: 0.7 },
  bitter: { RAGE: 0.6, PANIC: 0.2 },
  frustrated: { RAGE: 0.6 },
  upset: { RAGE: 0.6, PANIC: 0.4 },
  crazy: { RAGE: 0.5, PANIC: 0.3 },
  failing: { RAGE: 0.4, PANIC: 0.3 },
  broken: { RAGE: 0.4, FEAR: 0.2 },
  wrong: { RAGE: 0.3, FEAR: 0.1 },
  fix: { SEEKING: 0.3, RAGE: 0.2 },
  problems: { RAGE: 0.4, FEAR: 0.2 },
  unacceptable: { RAGE: 0.65 },
  disappointed: { RAGE: 0.4, PANIC: 0.3 },
  useless: { RAGE: 0.5, PANIC: 0.2 },
  sick: { RAGE: 0.4, PANIC: 0.3 },
  enough: { RAGE: 0.4 },
  done: { RAGE: 0.3 },
  stop: { RAGE: 0.3, FEAR: 0.2 },
  frustrating: { RAGE: 0.6 },
  frustration: { RAGE: 0.6 },
  annoyed: { RAGE: 0.5 },
  annoying: { RAGE: 0.5 },
  irritated: { RAGE: 0.5 },
  irritating: { RAGE: 0.5 },
  infuriating: { RAGE: 0.8 },
  outraged: { RAGE: 0.9 },
  outrageous: { RAGE: 0.7 },
  ridiculous: { RAGE: 0.5 },
  absurd: { RAGE: 0.4, PLAY: 0.2 },
  stupid: { RAGE: 0.6 },
  idiot: { RAGE: 0.7 },
  terrible: { RAGE: 0.5, FEAR: 0.2 },
  awful: { RAGE: 0.5, PANIC: 0.2 },
  horrible: { RAGE: 0.5, FEAR: 0.2 },
  unacceptable: { RAGE: 0.7 },
  disgusting: { RAGE: 0.6 },
  disgust: { RAGE: 0.5 },
  revolting: { RAGE: 0.6 },
  repulsive: { RAGE: 0.6 },
  gross: { RAGE: 0.4 },
  damn: { RAGE: 0.4 },
  shit: { RAGE: 0.5 },
  fuck: { RAGE: 0.5 },
  fucking: { RAGE: 0.5 },
  scream: { RAGE: 0.6, FEAR: 0.2 },
  yell: { RAGE: 0.6 },
  fight: { RAGE: 0.6 },
  destroy: { RAGE: 0.7 },
  kill: { RAGE: 0.6 },
  revenge: { RAGE: 0.7 },
  betray: { RAGE: 0.7, PANIC: 0.2 },
  betrayal: { RAGE: 0.7, PANIC: 0.3 },
  unfair: { RAGE: 0.6 },
  injustice: { RAGE: 0.7, CARE: 0.2 },
  sucks: { RAGE: 0.6 },
  worst: { RAGE: 0.6 },
  ruined: { RAGE: 0.6, PANIC: 0.3 },
  disaster: { RAGE: 0.5, FEAR: 0.5 },
  mess: { RAGE: 0.4, PANIC: 0.2 },
  tired: { RAGE: 0.3, PANIC: 0.3 },
  dissapointed: { PANIC: 0.5, RAGE: 0.3 },
  dissapoint: { PANIC: 0.5, RAGE: 0.3 },
  disappointing: { PANIC: 0.5, RAGE: 0.3 },
  complicated: { RAGE: 0.3, FEAR: 0.3 },
  difficult: { RAGE: 0.3, FEAR: 0.2 },
  impossible: { RAGE: 0.5, FEAR: 0.4 },
  unbearable: { RAGE: 0.6, PANIC: 0.5 },
  pathetic: { RAGE: 0.5, PANIC: 0.3 },
  garbage: { RAGE: 0.6 },
  trash: { RAGE: 0.6 },
  crap: { RAGE: 0.5 },
  craziness: { RAGE: 0.5, PANIC: 0.3 },
  insane: { RAGE: 0.5, FEAR: 0.2 },
  ugh: { RAGE: 0.4 },
  wtf: { RAGE: 0.7 },
  argh: { RAGE: 0.5 },
  ffs: { RAGE: 0.7 },
  nope: { RAGE: 0.2 },
  nah: { RAGE: 0.1 },

  // ═══════════════════════════════════════════
  // FEAR / ANXIETY
  // ═══════════════════════════════════════════
  afraid: { FEAR: 0.8 },
  scared: { FEAR: 0.8 },
  terrified: { FEAR: 0.9 },
  terror: { FEAR: 0.9 },
  frightened: { FEAR: 0.8 },
  frightening: { FEAR: 0.7 },
  scary: { FEAR: 0.7 },
  fear: { FEAR: 0.8 },
  fearful: { FEAR: 0.8 },
  anxious: { FEAR: 0.7 },
  anxiety: { FEAR: 0.7 },
  nervous: { FEAR: 0.6 },
  uneasy: { FEAR: 0.5 },
  dread: { FEAR: 0.8 },
  dreading: { FEAR: 0.7 },
  panic: { FEAR: 0.7, PANIC: 0.3 },
  panicking: { FEAR: 0.7, PANIC: 0.3 },
  danger: { FEAR: 0.7 },
  dangerous: { FEAR: 0.7 },
  threat: { FEAR: 0.7 },
  threatening: { FEAR: 0.7 },
  risk: { FEAR: 0.5, SEEKING: 0.2 },
  risky: { FEAR: 0.5, SEEKING: 0.2 },
  alarming: { FEAR: 0.6 },
  alarm: { FEAR: 0.6 },
  warning: { FEAR: 0.5 },
  caution: { FEAR: 0.4 },
  careful: { FEAR: 0.4, CARE: 0.2 },
  vulnerable: { FEAR: 0.6, CARE: 0.2 },
  exposed: { FEAR: 0.5 },
  trapped: { FEAR: 0.7, PANIC: 0.2 },
  cornered: { FEAR: 0.7 },
  helpless: { FEAR: 0.6, PANIC: 0.3 },
  powerless: { FEAR: 0.6, PANIC: 0.2 },
  overwhelmed: { FEAR: 0.5, PANIC: 0.4 },
  drowning: { FEAR: 0.5, PANIC: 0.5 },
  suffocating: { FEAR: 0.6, PANIC: 0.4 },
  nightmare: { FEAR: 0.7 },
  horror: { FEAR: 0.8 },
  creepy: { FEAR: 0.5 },
  eerie: { FEAR: 0.5 },
  sinister: { FEAR: 0.6 },
  doom: { FEAR: 0.7, PANIC: 0.2 },
  paranoid: { FEAR: 0.7 },
  suspicious: { FEAR: 0.5 },

  // ═══════════════════════════════════════════
  // SADNESS / PANIC (separation distress)
  // ═══════════════════════════════════════════
  sad: { PANIC: 0.7 },
  sadness: { PANIC: 0.7 },
  depressed: { PANIC: 0.8 },
  depression: { PANIC: 0.8 },
  cry: { PANIC: 0.7 },
  crying: { PANIC: 0.7 },
  tears: { PANIC: 0.6 },
  weep: { PANIC: 0.7 },
  grief: { PANIC: 0.9, CARE: 0.1 },
  grieving: { PANIC: 0.8, CARE: 0.1 },
  mourn: { PANIC: 0.8, CARE: 0.1 },
  mourning: { PANIC: 0.8, CARE: 0.1 },
  loss: { PANIC: 0.7 },
  lost: { PANIC: 0.5, FEAR: 0.2 },
  lonely: { PANIC: 0.7 },
  loneliness: { PANIC: 0.8 },
  alone: { PANIC: 0.6 },
  isolated: { PANIC: 0.7 },
  abandoned: { PANIC: 0.8, RAGE: 0.1 },
  rejection: { PANIC: 0.7, RAGE: 0.1 },
  rejected: { PANIC: 0.7, RAGE: 0.1 },
  heartbroken: { PANIC: 0.8, CARE: 0.1 },
  heartbreak: { PANIC: 0.8 },
  broken: { PANIC: 0.6 },
  empty: { PANIC: 0.6 },
  hollow: { PANIC: 0.6 },
  numb: { PANIC: 0.5 },
  hopeless: { PANIC: 0.8 },
  despair: { PANIC: 0.9 },
  desperate: { PANIC: 0.7, FEAR: 0.2 },
  miserable: { PANIC: 0.7 },
  suffering: { PANIC: 0.7, CARE: 0.1 },
  pain: { PANIC: 0.6, FEAR: 0.1 },
  painful: { PANIC: 0.6, FEAR: 0.1 },
  hurt: { PANIC: 0.6, RAGE: 0.1 },
  hurting: { PANIC: 0.6 },
  wounded: { PANIC: 0.6 },
  devastated: { PANIC: 0.9 },
  shattered: { PANIC: 0.8 },
  crushed_emotion: { PANIC: 0.7 }, // disambiguated from "crushed it"
  regret: { PANIC: 0.6 },
  remorse: { PANIC: 0.6, CARE: 0.2 },
  guilt: { PANIC: 0.6, CARE: 0.2 },
  guilty: { PANIC: 0.6 },
  shame: { PANIC: 0.7 },
  ashamed: { PANIC: 0.7 },
  worthless: { PANIC: 0.8 },
  failure: { PANIC: 0.6, FEAR: 0.2 },
  failed: { PANIC: 0.5, FEAR: 0.2 },
  sigh: { PANIC: 0.3 },
  exhausted: { PANIC: 0.5, FEAR: 0.1 },
  tired: { PANIC: 0.3 },
  drained: { PANIC: 0.5 },
  burnout: { PANIC: 0.6 },
  goodbye: { PANIC: 0.4, CARE: 0.3 },
  farewell: { PANIC: 0.4, CARE: 0.3 },

  // ═══════════════════════════════════════════
  // DESIRE / LUST (passion, wanting)
  // ═══════════════════════════════════════════
  want: { LUST: 0.3, SEEKING: 0.3 },
  need: { LUST: 0.3, SEEKING: 0.2 },
  crave: { LUST: 0.7 },
  craving: { LUST: 0.7 },
  desire: { LUST: 0.7, SEEKING: 0.2 },
  passion: { LUST: 0.5, SEEKING: 0.3 },
  passionate: { LUST: 0.5, SEEKING: 0.3 },
  obsessed: { LUST: 0.6, SEEKING: 0.3 },
  obsession: { LUST: 0.6 },
  tempt: { LUST: 0.5 },
  tempting: { LUST: 0.5 },
  temptation: { LUST: 0.6 },
  irresistible: { LUST: 0.6 },
  yearn: { LUST: 0.5, PANIC: 0.3 },
  yearning: { LUST: 0.5, PANIC: 0.3 },
  hunger: { LUST: 0.4, SEEKING: 0.3 },
  thirst: { LUST: 0.4, SEEKING: 0.3 },
  ache: { LUST: 0.3, PANIC: 0.4 },
  longing: { LUST: 0.4, PANIC: 0.4 },
  attract: { LUST: 0.5, SEEKING: 0.2 },
  attraction: { LUST: 0.6 },
  attractive: { LUST: 0.5 },
  sexy: { LUST: 0.7 },
  hot: { LUST: 0.4, PLAY: 0.2 },
  seductive: { LUST: 0.7 },
  intimate: { LUST: 0.5, CARE: 0.3 },
  intimacy: { LUST: 0.5, CARE: 0.4 },

  // ═══════════════════════════════════════════
  // SURPRISE (routes to SEEKING mostly)
  // ═══════════════════════════════════════════
  wow: { SEEKING: 0.5, PLAY: 0.4 },
  whoa: { SEEKING: 0.5, PLAY: 0.3 },
  omg: { SEEKING: 0.4, PLAY: 0.4 },
  shocking: { SEEKING: 0.5, FEAR: 0.3 },
  shocked: { SEEKING: 0.4, FEAR: 0.3 },
  unexpected: { SEEKING: 0.6 },
  unbelievable: { SEEKING: 0.5, PLAY: 0.3 },
  mindblown: { SEEKING: 0.6, PLAY: 0.3 },
  astonishing: { SEEKING: 0.6, PLAY: 0.2 },
  stunned: { SEEKING: 0.5, FEAR: 0.2 },
  speechless: { SEEKING: 0.4, PLAY: 0.2 },
  incredible: { SEEKING: 0.5, PLAY: 0.4 },

  // ═══════════════════════════════════════════
  // DOMAIN-SPECIFIC: Tech/Building
  // ═══════════════════════════════════════════
  code: { SEEKING: 0.5 },
  coding: { SEEKING: 0.6, PLAY: 0.2 },
  debug: { SEEKING: 0.5, RAGE: 0.2 },
  bug: { RAGE: 0.3, SEEKING: 0.3 },
  deploy: { SEEKING: 0.5, PLAY: 0.3 },
  ship: { SEEKING: 0.5, PLAY: 0.4 },
  merge: { SEEKING: 0.4 },
  refactor: { SEEKING: 0.5 },
  hack: { SEEKING: 0.6, PLAY: 0.3 },
  architecture: { SEEKING: 0.7 },
  integration: { SEEKING: 0.6 },
  pipeline: { SEEKING: 0.5 },
  plugin: { SEEKING: 0.5 },
  framework: { SEEKING: 0.5 },
  algorithm: { SEEKING: 0.6 },

  // ═══════════════════════════════════════════
  // DOMAIN-SPECIFIC: Faith/Theology
  // ═══════════════════════════════════════════
  god: { CARE: 0.5, SEEKING: 0.3 },
  christ: { CARE: 0.6, SEEKING: 0.2 },
  church: { CARE: 0.6 },
  liturgy: { CARE: 0.5, SEEKING: 0.3 },
  orthodox: { CARE: 0.5, SEEKING: 0.3 },
  theology: { SEEKING: 0.7, CARE: 0.2 },
  scripture: { SEEKING: 0.5, CARE: 0.3 },
  soul: { CARE: 0.5, SEEKING: 0.4 },
  spirit: { CARE: 0.5, SEEKING: 0.3 },
  salvation: { CARE: 0.6, SEEKING: 0.2 },
  grace: { CARE: 0.7 },
  sin: { PANIC: 0.3, FEAR: 0.3 },
  repentance: { CARE: 0.4, PANIC: 0.3 },
  resurrection: { SEEKING: 0.5, CARE: 0.3, PLAY: 0.2 },
};

// ═══════════════════════════════════════════
// EMOJI AFFECT MAP
// ═══════════════════════════════════════════
export const EMOJI_AFFECTS = {
  "😂": { PLAY: 0.8 },
  "🤣": { PLAY: 0.9 },
  "😭": { PANIC: 0.6 },
  "😢": { PANIC: 0.5 },
  "😡": { RAGE: 0.7 },
  "🤬": { RAGE: 0.8 },
  "😤": { RAGE: 0.5 },
  "😰": { FEAR: 0.6 },
  "😨": { FEAR: 0.7 },
  "😱": { FEAR: 0.8 },
  "🤔": { SEEKING: 0.5 },
  "💡": { SEEKING: 0.6, PLAY: 0.2 },
  "❤️": { CARE: 0.7 },
  "💕": { CARE: 0.7, LUST: 0.1 },
  "💝": { CARE: 0.7 },
  "🙏": { CARE: 0.6 },
  "🤗": { CARE: 0.7, PLAY: 0.2 },
  "🙌": { PLAY: 0.6, CARE: 0.2 },
  "🔥": { SEEKING: 0.4, PLAY: 0.4 },
  "🎉": { PLAY: 0.8 },
  "🥳": { PLAY: 0.8 },
  "💪": { SEEKING: 0.5, PLAY: 0.3 },
  "🏆": { PLAY: 0.5, SEEKING: 0.4 },
  "✅": { PLAY: 0.4, SEEKING: 0.3 },
  "😮": { SEEKING: 0.5 },
  "🤯": { SEEKING: 0.6, PLAY: 0.2 },
  "💀": { PLAY: 0.6 },
  "😏": { PLAY: 0.4, LUST: 0.2 },
  "🤩": { PLAY: 0.5, SEEKING: 0.3, LUST: 0.1 },
  "😊": { PLAY: 0.5, CARE: 0.3 },
  "🥰": { CARE: 0.7, LUST: 0.2 },
  "😍": { CARE: 0.4, LUST: 0.4, PLAY: 0.1 },
  "👀": { SEEKING: 0.4 },
  "🤘": { PLAY: 0.6, SEEKING: 0.2 },
  "👍": { CARE: 0.3, PLAY: 0.3 },
  "💔": { PANIC: 0.7 },
  "😩": { PANIC: 0.4, RAGE: 0.2 },
  "🥺": { PANIC: 0.4, CARE: 0.3 },
  "🫡": { CARE: 0.3, PLAY: 0.3 },
};

export default LEXICON;
