---
name: niche-selection
description: Select and refine a profitable, focused niche for a solopreneur business. Use when deciding which market segment to serve, narrowing a broad idea into a defensible position, or evaluating whether a niche is worth committing to. Covers niche generation, multi-criteria scoring, validation checks, and the Who+What+Why positioning formula. Trigger on "pick a niche", "what niche should I target", "narrow my market", "find my niche", "choose a niche", "is this niche viable", "niche down".
---

# Niche Selection

## Why This Matters for Solopreneurs
You cannot outspend, outhire, or out-market a funded competitor. What you can do is out-focus them. A tight niche lets you speak the customer's exact language, dominate a small pond via word-of-mouth and SEO, charge premium prices (specialist > generalist), and build a focused marketing strategy on a lean budget. The goal: become the obvious choice for one specific group of people.

---

## Step 1: Generate Niche Candidates (Minimum 10)

Brainstorm widely before narrowing. Use these three lenses:

**From your own experience:**
- What industries have you worked in or consulted for?
- What specific problems did you solve more than once?
- What do people already come to you for help with, even informally?
- What frustrations did you personally have that no tool solved well?

**From market signals:**
- What are people complaining about repeatedly on Reddit, forums, Twitter?
- What's trending on Product Hunt or in Y Combinator batches?
- What SaaS categories are growing fastest? (Check SaaS Stats, G2 Buyer's Guide)
- What new regulations or market shifts are creating new pain points?

**From intersections (the sweet spot):**
The formula: [Specific customer type] + [Specific problem] = niche.
- "E-commerce founders" + "inventory forecasting" = niche
- "Solo consultants" + "client contract automation" = niche
- "Restaurant owners" + "staff scheduling and tip splitting" = niche

Write all candidates down. No filtering yet. Quantity first.

---

## Step 2: Score Every Candidate

Rate each niche on these six dimensions (1-5 scale each):

| Criteria | Weight | How to Assess |
|---|---|---|
| **Pain intensity** | 25% | How badly does this segment feel the problem? Would they pay to eliminate it? |
| **Your personal advantage** | 20% | Do you have skills, access, credibility, or insider knowledge here that others don't? |
| **Market size** | 20% | Are there enough people/companies in this niche to build a sustainable business? (Aim: >10K reachable) |
| **Monetization potential** | 15% | Can you charge a price that, at realistic volume, sustains your income? |
| **Competition landscape** | 10% | Some competition = proven demand. Zero competition = possible red flag. Moderate competition with gaps = ideal. |
| **Growth trajectory** | 10% | Is this niche expanding, stable, or shrinking? |

**Weighted score = Σ (score × weight).** Top 3 candidates advance to validation.

---

## Step 3: Validate Top 3 Candidates

For each finalist, run these five quick checks. Takes 2-4 hours total per niche.

**1. Search volume check**
Google the primary keyword for this niche. Check Google Trends for 12-month trajectory. Is there sustained, growing interest? A flat or declining trend is a warning.

**2. Community check**
Do active communities exist for this niche? (Subreddits with 5K+ members, active Slack/Discord servers, Facebook groups with daily posts.) Active community = active people with this problem who talk to each other = your future marketing channel.

**3. Competitor gap check**
Find 3-5 tools or services already in this niche. Map their feature sets and read their negative reviews. Identify one clear gap that multiple customers complain about. That gap is your opening.

**4. Pricing reality check**
What do existing solutions in this niche charge? Is there pricing room for your model? If everyone charges $9/month and the market expects free tools, your economics may not work.

**5. Talk to 3 real people in this niche**
LinkedIn, community posts, or warm intros. Ask 5 minutes of questions: What tools do you use? What's broken about them? What would you pay to fix it? If they light up describing the problem, you've found a live nerve.

**Kill check:** A niche that fails 2+ of these checks is not ready. Either iterate on the definition or drop it.

---

## Step 4: Refine Into a Positioning Statement

A good niche is sharp enough that you can answer YES to every one of these:

- Can I name a specific type of person this is for?
- Can I describe one specific problem they have?
- Can I explain in one sentence why my solution beats what they're doing now?
- Would this person immediately recognize they need this the moment they hear about it?

**Use the Who + What + Why formula to write your positioning statement:**

```
[Specific customer segment] struggling with [specific problem]
who need [specific outcome], and current solutions fall short
because [specific gap I fill].
```

**Good example:**
"Freelance web developers managing 3-8 client projects simultaneously, struggling with status communication and revision tracking, who need automated client-facing progress reports — and current PM tools like Basecamp are too heavy and generic for their workflow."

**Bad example:**
"Small businesses that need better tools." (Too vague. Who specifically? What problem specifically?)

**Refinement loop:** If your statement is longer than 2 sentences or feels generic, you haven't narrowed enough. Cut it down or tighten the customer/problem definition.

---

## Step 5: Final Niche Commitment Checklist

Before you commit time and money, confirm every box:

- [ ] At least 10,000 reachable potential customers exist in this niche
- [ ] At least one competitor exists (demand proof) but no more than 2-3 dominant ones
- [ ] You have identified a specific, validated gap in what competitors offer
- [ ] You can reach this niche through channels you understand (SEO, communities, direct outreach, paid)
- [ ] The niche has budget — they are already spending money on adjacent solutions
- [ ] You can sustain interest and motivation working on this for 12+ months
- [ ] You have or can quickly build credibility here (portfolio piece, case study, community presence)

---

## Common Niche Mistakes to Avoid
- **Too broad:** "Small businesses" is not a niche. "SaaS founders bootstrapping their first product" is.
- **Too narrow:** "Left-handed graphic designers in Austin." The pool is too small to build a business.
- **Passion over pain:** You love the topic but nobody's paying to solve it. Passion is a bonus — pain + budget = business.
- **Ignoring your edge:** The best niche is where YOUR specific background gives you credibility that competitors cannot easily copy. Don't overlook this.
- **Skipping validation:** Picking a niche from theory alone. Always talk to real people first.
