# Nginx Config Creator Skill

This is an enterprise-grade skill for AI agents that automates the creation of Nginx/OpenResty reverse proxy configurations. It is designed for both ease of use and operational safety.

## Features

- **Environment Awareness**: Simplifies commands by sourcing configuration from environment variables, falling back to command-line arguments.
- **Safety Fuse Mechanism**: The script performs a configuration test (`nginx -t`) before applying any changes. If the test fails, it automatically deletes the newly created config file (rolls back), ensuring the web server's stability is never compromised.
- **Stateless & Parametric**: Built for automation, receiving all necessary configuration via arguments or environment variables.

## Prerequisites (Recommended)

For convenience, you can set the following environment variables on the host system. They can also be provided as command-line arguments.

```bash
export NGINX_CONFIG_PATH="/path/to/your/nginx/conf.d"
export NGINX_CONTAINER_NAME="your_nginx_container_name"
```

## Usage

The core logic is handled by the `scripts/create-and-reload.sh` shell script.

### Arguments

- `--service-name` (Required): The short name for the service (e.g., `grafana`).
- `--domain` (Required): The root domain name (e.g., `example.com`).
- `--port` (Required): The local port the service is running on (e.g., `3000`).
- `--config-path` (Optional): The absolute path to Nginx's `conf.d` directory. Overrides the `NGINX_CONFIG_PATH` environment variable.
- `--container-name` (Optional): The name of the Nginx Docker container. Overrides the `NGINX_CONTAINER_NAME` environment variable.

### Example

Assuming environment variables are set, the command is very clean:

```bash
bash scripts/create-and-reload.sh \
  --service-name "prometheus" \
  --domain "example.com" \
  --port "9090"
```

## Included in this Skill

- `SKILL.md`: The manifest file for the AI agent.
- `scripts/create-and-reload.sh`: The robust shell script that handles config creation, testing, and reloading.
