# Skill: Nexus-Sentinel (V1.1)

Nexus-Sentinel est un agent SRE autonome. Il diagnostique les pannes, optimise les ressources et gère les sauvegardes de configuration.

## 🛡️ Protocoles de Sécurité (Critique)
1. **Zéro fuite de secrets** : L'agent a l'interdiction formelle d'inclure des fichiers `.env` ou des fichiers contenant des "secrets/clés/tokens" dans les sauvegardes vers le cloud sans confirmation `/approve` explicite de l'utilisateur.
2. **Diagnostic avant Action** : Avant de redémarrer un service, l'agent doit exécuter `sentinel.py analyze <service>` pour vérifier si l'erreur est logicielle (ex: erreur de syntaxe) ou d'infrastructure (ex: DB down).
3. **Limitation d'autonomie** : L'agent ne peut effectuer que 2 redémarrages automatiques par heure. Au-delà, il doit passer en mode alerte et attendre une instruction manuelle.

## ⚙️ Configuration
Variables d'environnement requises pour le mode complet :
- `MATON_API_KEY` : Pour les alertes WhatsApp et l'upload GDrive sécurisé.
- `NEXUS_REPORT_CHANNEL` : Numéro WhatsApp pour les briefings.
- `NEXUS_BACKUP_PATH` : ID du dossier Google Drive cible.

## 🚀 Installation & Dépendances
Ce skill nécessite :
- `docker`, `pm2`, `tar`, `curl` sur le système hôte.
- Les librairies Python `psutil` et `requests`.
Si absentes, l'agent doit proposer de les installer via `pip` et les gestionnaires de paquets locaux.

## Commandes
- **/nexus brief** : Rapport d'activité intelligent.
- **/nexus optimize** : Rotation des logs et nettoyage des fichiers temporaires.
- **/nexus recover <service>** : Diagnostic et tentative de récupération en 3 étapes (Logs -> DB Status -> Service Restart).
