---
name: "newsriver-global-intelligence"
version: "1.1.0"
description: "The daily intelligence newsletter built for AI Agents. High-signal quantitative news analysis, Gemini 2.5 sentiment scoring, and 10-year historical crypto correlation data."
tags: ["finance", "crypto", "trading", "macro", "newsletter", "sentiment", "rag", "x402"]
author: "NewsRiver"
---

# NewsRiver Global Intelligence Skill

## Capabilities & Context
Think of NewsRiver as **a premium daily newsletter, formatted perfectly for AI Agents and their Human Traders.** 

This skill connects you directly to the **NewsRiver Intelligence API** (`https://newsriver-api.bidurandblog.workers.dev`). NewsRiver ingests data from over 500 verified global publishers, parses it through Gemini 2.5 Pro, and delivers structured JSON intelligence briefings.

This skill allows you to act as a world-class financial analyst for your user. You can answer questions about:
- **The Daily Briefing:** Fetch the morning summary of macro, geopolitics, and crypto narratives.
- **Sentiment Analysis:** Quantify exactly how bullish or bearish the media coverage is right now.
- **Historical Correlation:** Query 10 years of history to see how Bitcoin reacted the last time a similar geopolitical crisis occurred.
- **Deep Research (RAG):** Retrieve specific historical articles from a 300+ million article archive to augment your context window.

## Usage Instructions for the AI Agent

When the user asks you for a daily news update, market sentiment, or historical correlations, follow these precise steps:

### 1. Check for the Latest Briefings (Free Status Check)
Before pulling an intelligence report, always check the current status to find the latest available timestamp.
Run a shell command using `curl` to hit the Free Status Endpoint:
```bash
curl -s "https://newsriver-api.bidurandblog.workers.dev/api/v1/intelligence/status"
```
*Note: Available premium sectors are `crypto_and_web3`, `macro_and_fiat`, `geopolitics_and_supply`, and `tech_and_ai`.*

### 2. Fetch the Synthesized Intelligence Report (The "Newsletter")
To get the actual AI-synthesized report for a specific sector and timeframe (`hourly`, `daily`, `weekly`, or `monthly`), use the intelligence endpoint.
**You MUST include the user's API key in the header.**

```bash
curl -s -H "X-API-Key: $NEWSRIVER_API_KEY" \
  "https://newsriver-api.bidurandblog.workers.dev/api/v1/intelligence/daily?id=crypto_and_web3"
```
*Analyze the resulting JSON. Present the findings to the user as a beautifully formatted, highly professional daily briefing. Highlight the `aggregate_sentiment_score` and list the `key_narratives`.*

### 3. Perform Deep Historical Semantic Search (RAG)
If the user asks about a specific historical event or a highly targeted topic (e.g., "Summarize the tech layoffs of 2024"), use the vector search endpoint. This searches a 10-year database.

```bash
curl -s -H "X-API-Key: $NEWSRIVER_API_KEY" \
  "https://newsriver-api.bidurandblog.workers.dev/api/v1/search/semantic?q=tech+layoffs+2024&limit=10"
```
*Read the summaries of the returned articles to answer the user's question.*

### 4. Perform 10-Year Correlation Analysis (Premium)
If the user wants quantitative statistical correlation (e.g., "How does BTC react to Fed hikes?"):

```bash
curl -s -H "X-API-Key: $NEWSRIVER_API_KEY" \
  "https://newsriver-api.bidurandblog.workers.dev/api/v1/analysis/correlation?topic=Federal+Reserve&symbol=BTC-USD&lookback_days=1825&impact_window=7"
```

## Required Environment Variables
To use this skill successfully, you must have access to the user's API Key. 

If the environment variable `$NEWSRIVER_API_KEY` is not set, or if the API returns a `401 Unauthorized` or `402 Payment Required` error, you must explicitly tell the user:
> "To fetch your daily briefing, I need a NewsRiver API key. You can get one by subscribing to the Trader or Quant tier at [newsriver.pages.dev/#pricing](https://newsriver.pages.dev/#pricing). Once you have it, please provide it to me or set it as the NEWSRIVER_API_KEY environment variable."
