---
name: Newsletter
description: Create, grow, and monetize newsletters with effective content and subscriber strategies.
metadata: {"clawdbot":{"emoji":"📧","os":["linux","darwin","win32"]}}
---

## Subject Lines

- Curiosity gap—promise value, don't reveal everything
- Specific > vague: "5 tools I use daily" > "Useful tools"
- Numbers work—quantified promises feel tangible
- Personal: "you" and lowercase feels like friend
- Urgency when genuine—time-sensitive content only
- Test constantly—small changes, big impact on opens
- Avoid spam triggers—"FREE", all caps, excessive punctuation

## Preview Text

- Extension of subject, not repetition
- Complete the curiosity—add context that increases open
- Don't waste on "View in browser"—prime real estate
- First line of email becomes preview if not set—control it

## Content Structure

- TL;DR at top for skimmers—then expand below
- One main idea per issue—focus beats variety
- Scannable: headers, bullets, bold key phrases
- Consistent format—readers know what to expect
- Personal voice—distinct from generic corporate
- End with clear CTA—one action, not five

## Frequency

- Consistency over frequency—weekly better than sporadic daily
- Set expectations at signup—"Every Tuesday" not "sometimes"
- Quality per issue matters more—don't pad to hit schedule
- Test frequency changes—some audiences want more, some less

## Growth Strategies

- Lead magnet: valuable free resource for email
- Content upgrades: bonus content within popular posts
- Referral program: rewards for sharing
- Cross-promotions: swap with similar newsletters
- Social proof: subscriber count, testimonials
- Twitter/LinkedIn teasers—excerpt best parts publicly

## Landing Page

- Single focus: email capture—no other distractions
- Clear value proposition—what they get, how often
- Social proof—subscriber count, notable readers, testimonials
- Preview content—show what emails look like
- Low friction form—email only, name optional
- Mobile optimized—significant traffic from social

## Welcome Sequence

- Immediate welcome—confirm subscription, set expectations
- Best content showcase—send top 3 past issues
- Ask what they want—segment based on response
- Personal story—build connection, why you write
- Quick win—valuable content immediately

## Segmentation

- By interest: what topics they clicked
- By engagement: active vs dormant
- By source: different lead magnets = different interests
- By behavior: purchasers vs free only
- Personalize content per segment—relevance increases engagement

## Deliverability

- Warm up new domain—start small, increase volume
- Clean list regularly—remove bounces, long-term inactive
- Authenticate: SPF, DKIM, DMARC configured
- Easy unsubscribe—hidden unsubscribe hurts reputation
- Monitor spam complaints—above 0.1% is problem
- Avoid purchased lists—destroy reputation instantly

## Metrics

- Open rate: 40%+ good, below 20% problem—but Apple Mail inflates
- Click rate: 2-5% typical, depends on content type
- Growth rate: net new subscribers per period
- Reply rate: engagement signal, builds relationship
- Revenue per subscriber: for monetized newsletters

## Monetization

- Sponsorships: once established, charge per issue or CPM
- Premium tier: exclusive content, community access
- Products: courses, guides, templates
- Affiliate: products you genuinely recommend
- Classified ads: job boards, tools relevant to audience

## Sponsors

- Audience alignment—sponsor fits reader interest
- Clear "sponsored" label—transparency builds trust
- Limited per issue—one primary, maybe one classified
- Write ad yourself—matches voice, performs better
- Pricing: CPM model or flat rate based on audience value

## Re-engagement

- Segment inactive (90+ days no open)
- Win-back campaign: "Still interested?"
- Remove if no response—quality over quantity
- Different subject line style—pattern interrupt
- Final email: "Last chance before I remove you"

## Writing Habits

- Consistent publishing day—readers expect it
- Write for one person—specific reader in mind
- Share what you learned—curate and add insight
- Link to sources—credit and provide depth
- Proofread: typos damage credibility
