---
name: news-writing
description: 新闻素材收集、整理、写作、排版与校对的完整工作流。用于用户需要生成新闻稿、快讯、深度稿、企业新闻、活动报道，或需要对现有新闻内容进行事实核实、结构优化、标题导语改写、版式统一与发布前审校时。
---

# News Writing

按以下流程执行，确保内容可发布、可追溯、可复核。

## 1) 明确任务约束

先确认并记录：
- 新闻类型：快讯 / 通稿 / 深度稿 / 采访稿 / 活动报道
- 发布渠道：网站、公众号、邮件、内刊、社媒
- 目标读者：行业、地区、专业程度
- 输出要求：字数、语气、发布时间、是否需要中英双语

缺少约束时，先用保守默认：中性客观语气、标准新闻结构、便于二次排版的 Markdown。

## 2) 收集并整理素材

先建立“素材清单”再写作，素材至少包含：
- 原始来源：公告、采访记录、会议纪要、监管文件、统计数据
- 二级来源：权威媒体、机构网站、公开数据库
- 背景信息：时间线、关键人物/机构、历史对比数据

用表格整理素材，字段固定为：
- `编号` `事实陈述` `来源链接/出处` `时间` `地点` `可核实状态` `备注`

需要完整规范时，读取 [references/fact-check.md](references/fact-check.md)。

## 3) 写作前核实

仅把“已核实”事实写入正文；未核实内容放入“待确认列表”。

执行最小核实标准：
- 关键事实至少双来源交叉验证（原始来源优先）
- 时间、地名、人名、头衔、数字逐项核对
- 引述必须标注来源与语境，不改写原意
- 争议点显式标注“尚无独立证实”

## 4) 生成新闻正文

默认采用“倒金字塔结构”：
- 标题：结果导向，不堆砌形容词
- 导语：一句话交代 `谁-何时-何地-发生了什么-影响`
- 主体：按重要性递减展开，补充背景和数据
- 结尾：后续安排、官方回应或可执行信息

可直接基于模板产出：
- [assets/news-article-template.md](assets/news-article-template.md)

需要更多标题、导语、段落节奏规则时，读取 [references/writing-style.md](references/writing-style.md)。

## 5) 排版与可读性优化

在不改变事实前提下统一格式：
- 单段表达单一信息点
- 数字统一单位与格式（货币、百分比、同比/环比）
- 引用、数据、时间线使用小标题或列表分隔
- 保持“可扫描结构”：标题、小标题、短段、必要列表

## 6) 审校与发布前检查

发布前执行终检并输出两部分：
- `最终稿`
- `核实记录`（来源与未确认项）

终检清单：
- 事实准确：无未标注推测
- 逻辑完整：导语与正文一致
- 法律与合规：不含诽谤、隐私泄露、未经证实指控
- 语言质量：无错别字、病句、歧义指代
- 版式统一：标题层级、标点、空格、日期格式一致

## 输出格式

默认输出为以下三段：
1. `新闻正文`
2. `事实核验摘要`
3. `待补充信息`（如果为空，写“无”）
