---
name: news-cog
description: "Frontier search models with multi-angle research on every query. CellCog combines deep reasoning with SOTA search to produce accurate, comprehensive news briefs, reports, and digests — delivered ready for your agent to consume without flooding its context window. AI news summary, daily briefing, news digest, current events, trend monitoring, competitive intelligence, market updates."
metadata:
  openclaw:
    emoji: "📰"
author: CellCog
dependencies: [cellcog]
---

# News Cog - AI News Intelligence Powered by CellCog

**Frontier search models with multi-angle research on every query.**

CellCog combines deep reasoning with SOTA search models and multi-intent research to produce accurate, comprehensive news intelligence. Briefs, reports, and digests delivered ready for your agent to consume — without pulling hundreds of articles into your main agent's context window.

---

## Prerequisites

This skill requires the `cellcog` skill for SDK setup and API calls.

```bash
clawhub install cellcog
```

**Read the cellcog skill first** for SDK setup. This skill shows you what's possible.

**Quick pattern (v1.0+):**
```python
result = client.create_chat(
    prompt="[your news/briefing request]",
    notify_session_key="agent:main:main",
    task_label="news-task",
    chat_mode="agent"
)
```

---

## What You Can Get

### Daily Briefings

Concise, actionable summaries:

- **Morning Briefing**: "Give me today's top tech industry news — focus on AI, cloud, and enterprise software"
- **Market Open**: "Summarize pre-market news affecting FAANG stocks and semiconductor sector"
- **Industry Digest**: "Summarize this week's most important developments in renewable energy"
- **Startup News**: "What happened in startup funding this week? Series A+ rounds in fintech"

**Example prompt:**
> "Create a morning briefing for a startup CEO:
> 
> Focus areas:
> 1. AI industry developments (new models, funding, regulations)
> 2. SaaS market trends and notable deals
> 3. Macro economic signals (Fed, inflation, tech employment)
> 
> Format: Bullet-point brief with one-sentence summaries and source links.
> Highlight anything that requires immediate attention.
> Total length: Under 500 words — I need to scan this in 2 minutes."

### Competitive Intelligence

Monitor your competitive landscape:

- **Competitor Watch**: "What has Notion shipped or announced in the last 30 days?"
- **Market Moves**: "Summarize recent M&A activity in the cybersecurity sector"
- **Product Launches**: "What new AI developer tools launched this month?"
- **Funding Tracker**: "List all AI companies that raised $50M+ in the last 2 weeks"

### Trend Reports

Deeper analysis of emerging patterns:

- **Trend Analysis**: "What are the emerging trends in AI agent infrastructure? Analyze recent launches, funding, and technical developments"
- **Regulatory Watch**: "Summarize new AI regulations proposed or enacted globally in 2026"
- **Technology Shifts**: "Research the shift from RAG to long-context models — what are the latest developments?"

### Custom News Digests

Tailored to your specific needs:

- **Role-Specific**: "Create a weekly digest for a VP of Engineering at a fintech company"
- **Topic-Specific**: "Summarize everything published about quantum computing this week"
- **Region-Specific**: "What's happening in the European tech ecosystem this month?"
- **Event Coverage**: "Summarize the key announcements from AWS re:Invent 2026"

---

## Why CellCog for News?

### The Technical Edge

CellCog doesn't just search once and summarize — it runs **multi-angle research** across your query:

1. **Multiple search intents**: A single news query is decomposed into multiple research angles
2. **Frontier search models**: SOTA retrieval across hundreds of sources
3. **Deep reasoning**: Cross-references and synthesizes findings, not just concatenates
4. **Citation quality**: Sources traced back to original reporting, not aggregator summaries

| RSS Feeds / News Aggregators | CellCog News Cog |
|-----------------------------|------------------|
| Raw article firehose | Synthesized, prioritized intelligence |
| You filter and read | CellCog researches, reasons, and summarizes |
| Same view for everyone | Tailored to your role, industry, and priorities |
| Text links only | Structured briefs, PDF reports, or interactive dashboards |
| Floods your context | Delivers concise, agent-consumable output |

### Agent-Optimized Output

CellCog News Cog is designed with agent workflows in mind. The output is:
- **Concise** — won't overwhelm your main agent's context window
- **Structured** — clear sections, bullet points, and hierarchies
- **Actionable** — highlights what matters and why
- **Sourced** — includes citations when requested

---

## Output Formats

| Format | Best For |
|--------|----------|
| **Structured text** | Agent consumption, quick briefings |
| **PDF Report** | Professional distribution, archiving |
| **Interactive HTML** | Explorable dashboards with filters |
| **Markdown** | Integration into docs, wikis, or knowledge bases |

---

## Chat Mode for News

| Scenario | Recommended Mode |
|----------|------------------|
| Daily briefings, quick news summaries | `"agent"` |
| Competitive intelligence, single-topic digests | `"agent"` |
| Deep trend analysis, comprehensive industry reports | `"agent team"` |

**Use `"agent"` for most news tasks.** Daily briefings, competitive monitoring, and news digests execute well.

**Use `"agent team"` for deep trend analysis** — when you need multi-source synthesis across dozens of publications and research papers.

---

## Tips for Better News Intelligence

1. **Define your focus**: "Tech news" is too broad. "AI infrastructure and developer tools" is focused.

2. **Specify timeframe**: "Today's news", "this week", "last 30 days" — recency matters.

3. **Set the audience**: "For a technical audience" vs. "for a board of directors" changes depth and tone.

4. **Request structure**: "Bullet-point brief under 500 words" vs. "comprehensive PDF report with sections" — be explicit.

5. **Ask for citations**: "Include source URLs for each item" — when traceability matters.

6. **Indicate priority signals**: "Highlight anything about regulation changes or major funding rounds" — helps CellCog surface what matters to you.
