# NYC Lodging Guide

## By Budget

### Hostels ($30-100/night)
| Hostel | Location | Price | Notes |
|--------|----------|-------|-------|
| **HI NYC Hostel** | Upper West Side | ~$78 | Largest US hostel, 672 rooms, free events |
| **Chelsea International** | Chelsea | ~$41 | Free breakfast, central |
| **New York Moore** | Brooklyn | ~$35 | Largest in Brooklyn |

**Tips:** Book on Hostelworld. Bring padlock for lockers.

### Budget Hotels ($150-300/night)
| Hotel | Location | Price | Notes |
|-------|----------|-------|-------|
| **Riverside Tower** | Upper West Side | $150-300 | Best budget deal in Manhattan |
| **Pod Hotels** | Multiple | $150-250 | Compact, modern |
| **LIC Plaza Hotel** | Long Island City | $150-250 | 1 stop to Midtown |

### Mid-Range ($300-600/night)
| Hotel | Location | Notes |
|-------|----------|-------|
| **citizenM Times Square** | Times Square | Modern, tech-forward |
| **Freehand New York** | Gramercy | Fun vibe, good bar |
| **The Warwick** | Midtown | Old World elegance |

### Luxury ($600+/night)
- **The Plaza** — THE iconic NYC hotel
- **The Mercer** (SoHo) — Quiet elegance
- **Mandarin Oriental** — Central Park views

---

## Best Neighborhoods by Purpose

### First-Time Visitors
**Best:** Midtown, Flatiron, Times Square area
- Central, walk to major sights
- Easy subway access
- "Classic NYC" experience

### Business Travelers
**Best:** Midtown East, Financial District, Hudson Yards
- Near business districts
- Good airport access

### Families
**Best:** Upper West Side, Upper East Side
- Safe, residential
- Near Central Park
- Family museums (Natural History, Met)

### Hip/Young Travelers
**Best:** Williamsburg, Lower East Side
- Nightlife, trendy restaurants
- More affordable than Manhattan

---

## Neighborhood Comparison

| Area | Best For | Pros | Cons |
|------|----------|------|------|
| **Flatiron** | Overall best | Central, pleasant, less chaos | Few major sights |
| **Midtown** | First-timers | Walk to everything | Expensive, overwhelming |
| **UWS** | Families | Safe, quiet, parks | Far from downtown |
| **Williamsburg** | Young travelers | Hip, cheaper | Brooklyn = longer commute |
| **FiDi** | Budget | Affordable, historic | Dead at night |

## Areas to AVOID

- **Far uptown (above 125th)** — Long commute
- **Port Authority area** — Gritty, noisy
- **Parts of Midtown East** — Dead on weekends
- **Deep Brooklyn/Queens** — Unless you want local experience

---

## ⚠️ Airbnb Warning (Critical)

**NYC Airbnb regulations (since Sept 2023) are strictest in US:**
- Host MUST be present during stay
- Host must register with city
- 80%+ of Airbnb inventory disappeared
- Entire apartments for <30 days are illegal

**What this means:**
- Legal listings = renting a room while host is home
- If you book illegal listing, may get cancelled
- **Hotels are more reliable now**
- 30+ day stays: Airbnb is still legal

---

## Money-Saving Tips

- **January-March:** Cheapest hotels (cold, fewer tourists)
- **Long Island City:** 20-40% cheaper, 1 stop to Midtown
- **Downtown Brooklyn:** Quality hotels, lower prices
- **Avoid:** Thanksgiving, Christmas, New Year's weeks
- **Hotel Tonight app:** Last-minute deals
- **Book direct:** Sometimes cheaper than Booking.com
