# NYC Safety Guide

## Overview

**NYC is one of the safest large US cities.** Murder rate is BELOW the national average.

- Crime at historic lows (safest in a generation)
- Murders/shootings down 34%+ since 2021
- Over 750,000 subway rides per major felony

## Safe Areas

### Manhattan
- Upper West Side (especially 70s-90s)
- Upper East Side
- Tribeca
- Battery Park City
- Greenwich Village
- Financial District

### Brooklyn
- Brooklyn Heights ⭐ (safest in borough)
- Park Slope
- DUMBO
- Carroll Gardens/Cobble Hill
- Williamsburg (most parts)

### Queens
- Forest Hills
- Bayside
- Astoria (most parts)
- LIC (newer developments)

## Areas to Exercise Caution

**Higher crime (exercise awareness):**
- **Bronx:** South Bronx (Mott Haven, Hunts Point)
- **Brooklyn:** Brownsville, East New York, parts of Bed-Stuy
- **Manhattan:** East Harlem (north of 110th), parts of Washington Heights
- **Queens:** Parts of Jamaica, Far Rockaway

**Note:** Even "high crime" areas are generally fine during daytime with normal precautions.

## Subway Safety

### Daytime (6am-10pm)
- Very safe throughout system
- All major tourist lines well-patrolled
- Millions ride daily without incident

### Late Night (10pm-6am)
- Higher per-rider risk (fewer witnesses)
- Stick to well-lit areas near booth/cameras
- Use "off-hours waiting areas" (marked on platforms)
- Avoid empty cars; sit near other passengers
- Trust instincts — if car feels wrong, move

### Tips
- Stand away from platform edge
- Keep phone in pocket on platform (theft risk)
- Avoid displaying expensive jewelry
- Emergency intercoms in every car

## Common Crimes & Prevention

### Phone Snatching (#1 property crime)
- Most common at subway doors closing
- Keep phone in pocket during "transitional" moments
- Don't use phone while walking near curbs

### Pickpocketing
- Tourist areas (Times Square, etc.)
- Keep bags zipped, in front
- Don't flash cash

### Package Theft
- Use Amazon Lockers / UPS Access Points
- Buildings without doormen = higher risk

## General Tips

1. **Awareness:** Stay alert, avoid headphones at full volume
2. **Walking:** Stick to well-lit, busy streets at night
3. **Parks:** Avoid smaller parks after dark; Central Park closes 1am
4. **Scams:** Ignore CD sellers, charity clipboard people, three-card monte
5. **Times Square:** Ignore costume characters demanding tips, "monks" with bracelets

## Emergency

- **911** — Police, Fire, Medical emergency
- **311** — Non-emergency city services
- **Crime Stoppers:** 1-800-577-TIPS

## Perspective

NYC's crime is very low for a city of 8+ million. Standard urban awareness applies, but don't be paranoid — millions live here safely.
