---
name: ai-news-digest
description: 自动抓取并汇总 AI、科技行业的最新新闻，生成每日/每周新闻简报。支持多种来源，自动提取要点。
metadata: {"clawdbot":{"emoji":"🤖","requires":{},"primaryEnv":""}}
---

# AI News Digest

自动抓取并汇总 AI、科技行业的最新新闻，生成每日/每周新闻简报。

## 功能

- 📰 自动抓取 AI 新闻来源
- 📝 生成结构化摘要
- 🏷️ 按主题分类
- 📧 支持邮件发送
- 🌐 多语言支持

## 使用方法

### 生成今日简报

```bash
ai-news-digest today

# 指定输出格式
ai-news-digest today --format markdown

# 发送到邮箱
ai-news-digest today --email your@email.com
```

### 生成周报

```bash
ai-news-digest weekly

# 指定周报范围
ai-news-digest weekly --days 7
```

### 自定义来源

```bash
ai-news-digest custom --sources "hacker-news,techcrunch,reddit-ai"
```

## 配置

### 环境变量

```bash
# 可选：设置 OpenAI API Key 用于生成更智能的摘要
export OPENAI_API_KEY="your-api-key"

# 可选：SMTP 配置用于发送邮件
export SMTP_HOST="smtp.gmail.com"
export SMTP_PORT="587"
export SMTP_USER="your@email.com"
export SMTP_PASS="your-password"
```

## 输出示例

```markdown
# 🤖 AI News Digest - 2026-03-02

## 今日热点

### 1. OpenAI 发布新模型
**来源**: OpenAI Blog  
**摘要**: OpenAI 发布了最新的 GPT-5 模型，在推理能力上有显著提升...

### 2. Google DeepMind 新突破
**来源**: DeepMind Blog  
**摘要**: 研究团队在蛋白质折叠预测领域取得新进展...

## 行业动态

- AI 芯片需求持续增长
- 自动驾驶领域投资增加
- AI 伦理问题引发讨论

## 本周 Top 3

1. [链接1]
2. [链接2]
3. [链接3]

---
Generated by AI News Digest
```

## 新闻来源

默认支持的来源：

| 来源 | 说明 |
|------|------|
| Hacker News | 技术新闻聚合 |
| Reddit AI | AI 子论坛热门 |
| OpenAI Blog | 官方博客 |
| Google AI | Google AI 新闻 |
| TechCrunch | 科技媒体 |
| 36kr | 中文科技媒体 |

## 安装

```bash
# 无需额外依赖
# 使用内置的 web fetch 获取新闻
```

## 高级用法

### 过滤特定主题

```bash
# 只获取 LLM 相关新闻
ai-news-digest today --filter "llm,gpt,language-model"

# 只获取 AI 硬件
ai-news-digest today --filter "chip,gpu,hardware"
```

### 自定义格式

```bash
# 输出为 HTML 邮件格式
ai-news-digest today --format html --email newsletter@subscribers.com

# 输出为纯文本
ai-news-digest today --format text
```

## 自动化

### 设置每日自动推送

```bash
# 添加到 crontab
0 8 * * * ai-news-digest today --email your@email.com
```

## 变现思路

1. **Newsletter 订阅** - 每日/每周 AI 新闻简报
2. **付费订阅** - 深度分析版
3. **联盟营销** - 推荐 AI 工具和产品
4. **企业服务** - 为公司定制行业简报
