---
name: Network
description: Understand and troubleshoot computer networks with TCP/IP, DNS, routing, and diagnostic tools.
metadata: {"clawdbot":{"emoji":"🌐","os":["linux","darwin","win32"]}}
---

# Network Fundamentals

## TCP/IP Basics
- TCP guarantees delivery with retransmission — use for reliability (HTTP, SSH, databases)
- UDP is fire-and-forget — use for speed when loss is acceptable (video, gaming, DNS queries)
- Port numbers: 0-1023 privileged (need root), 1024-65535 available — common services have well-known ports
- Ephemeral ports for client connections — OS assigns randomly from high range

## DNS
- DNS resolution is cached at multiple levels — browser, OS, router, ISP — flush all when debugging
- TTL determines cache duration — lower before migrations, raise after for performance
- A record for IPv4, AAAA for IPv6, CNAME for aliases, MX for mail
- CNAME cannot exist at zone apex (root domain) — use A record or provider-specific alias
- `dig` and `nslookup` query DNS directly — bypass local cache for accurate results

## IP Addressing
- Private ranges: 10.x.x.x, 172.16-31.x.x, 192.168.x.x — not routable on internet
- CIDR notation: /24 = 256 IPs, /16 = 65536 IPs — each bit halves or doubles the range
- 127.0.0.1 is localhost — 0.0.0.0 means all interfaces, not a valid destination
- NAT translates private to public IPs — most home/office networks use this
- IPv6 eliminates NAT need — but dual-stack with IPv4 still common

## Common Ports
- 22: SSH — 80: HTTP — 443: HTTPS — 53: DNS
- 25/465/587: SMTP (mail sending) — 143/993: IMAP — 110/995: POP3
- 3306: MySQL — 5432: PostgreSQL — 6379: Redis — 27017: MongoDB
- 3000/8080/8000: Common development servers

## Troubleshooting Tools
- `ping` tests reachability — but ICMP may be blocked, no response doesn't mean down
- `traceroute`/`tracert` shows path — identifies where packets stop or slow down
- `netstat -tulpn` or `ss -tulpn` shows listening ports — find what's using a port
- `curl -v` shows full HTTP transaction — headers, timing, TLS negotiation
- `tcpdump` and Wireshark capture packets — last resort for deep debugging

## Firewalls and NAT
- Stateful firewalls track connections — allow response to outbound requests automatically
- Port forwarding maps external port to internal IP:port — required to expose services behind NAT
- Hairpin NAT for internal access to external IP — not all routers support it
- UPnP auto-configures port forwarding — convenient but security risk, disable on servers

## Load Balancing
- Round-robin distributes sequentially — simple but ignores server capacity
- Least connections sends to least busy — better for varying request durations
- Health checks remove dead servers — configure appropriate intervals and thresholds
- Sticky sessions (affinity) keep user on same server — needed for stateful apps, breaks scaling

## VPNs and Tunnels
- VPN encrypts traffic to exit point — all traffic appears from VPN server IP
- Split tunneling sends only some traffic through VPN — reduces latency for local resources
- WireGuard is modern and fast — simpler than OpenVPN, better performance
- SSH tunnels for ad-hoc port forwarding — `ssh -L local:remote:port` creates secure tunnel

## SSL/TLS
- TLS 1.2 minimum, prefer 1.3 — older versions have known vulnerabilities
- Certificate chain: leaf → intermediate → root — missing intermediate causes validation failures
- SNI allows multiple certs on one IP — older clients without SNI get default cert
- Let's Encrypt certs expire in 90 days — automate renewal or face outages

## Common Mistakes
- Assuming DNS changes are instant — TTL means old records persist in caches
- Blocking ICMP entirely — breaks path MTU discovery, causes mysterious failures
- Forgetting IPv6 — services may be accessible on IPv6 even with IPv4 firewall
- Hardcoding IPs instead of hostnames — breaks when IPs change
- Not checking both TCP and UDP — some services need UDP (DNS, VPN, game servers)
- Confusing latency and bandwidth — high bandwidth doesn't mean low latency
