#!/usr/bin/env bash
set -euo pipefail

# Create a netlify.toml for a Hugo site whose base dir is the current folder.
# Usage:
#   ./hugo_netlify_toml.sh [HUGO_VERSION]

HUGO_VERSION="${1:-0.155.1}"

cat > netlify.toml <<EOF
[build]
  command = "hugo --minify"
  publish = "public"

[build.environment]
  HUGO_VERSION = "${HUGO_VERSION}"
EOF

echo "Wrote $(pwd)/netlify.toml (HUGO_VERSION=${HUGO_VERSION})"