---
name: netlify
description: Use the Netlify CLI (netlify) to create/link Netlify sites and set up CI/CD (continuous deployment) from GitHub, especially for monorepos (multiple sites in one repo like Hugo sites under sites/<domain>). Use when Avery asks to deploy a new site, connect a repo to Netlify, configure build/publish settings, set environment variables, enable deploy previews, or automate Netlify site creation.
---

# netlify

Use the `netlify` CLI to create projects (“sites”), link local folders, and configure CI/CD from GitHub.

## Pre-reqs

- `netlify --version`
- Logged in (`netlify login`) **or** provide `--auth $NETLIFY_AUTH_TOKEN`.
- Know the Netlify team/account slug you want to create sites under (optional but recommended).

Helpful checks:

```bash
netlify status
netlify sites:list
```

## Monorepo pattern (recommended)

For **one repo with multiple sites** (e.g. `sites/seattlecustomboatparts.com`, `sites/floridacustomerboatparts.com`):

- Create **one Netlify site per domain**.
- Set the site’s **Base directory** to that subfolder.
- Put a `netlify.toml` *inside that subfolder*.

This keeps each domain’s build config self-contained.

### Hugo subfolder `netlify.toml`

Create `sites/<domain>/netlify.toml`:

```toml
[build]
  command = "hugo --minify"
  publish = "public"

[build.environment]
  HUGO_VERSION = "0.155.1"
```

(Adjust HUGO_VERSION as needed.)

## Fast workflow: create + link + init CI/CD

### 1) Create a Netlify site (project)
Run inside the site folder you want to deploy (base dir):

```bash
cd sites/<domain>
netlify sites:create --name <netlify-site-name> --account-slug <team> --with-ci
```

Notes:
- `--with-ci` starts CI hooks setup.
- If you need manual control, add `--manual`.

### 2) Link local folder to the created site
If not linked already:

```bash
netlify link
```

### 3) Connect to GitHub for continuous deployment

```bash
netlify init
```

This is usually interactive (select Git remote/repo + build settings). For automation we can pre-create `netlify.toml` and then accept defaults.

## Environment variables

Set per-site vars:

```bash
netlify env:set VAR_NAME value
netlify env:list
```

Useful for monorepos:
- `CONTACT_EMAIL` (or other shared config)

## Deploy

Manual deploys (handy for quick preview):

```bash
netlify deploy            # draft deploy
netlify deploy --prod     # production deploy
```

## Included scripts

- `scripts/hugo_netlify_toml.sh`: create a `netlify.toml` in a Hugo subfolder
- `scripts/netlify_monorepo_site.sh`: helper to create/link/init a site for a subfolder

When using scripts, prefer passing `NETLIFY_AUTH_TOKEN` via env for non-interactive runs.
