"""
Automatically generated pytest tests for sample_functions

This file was generated by py-test-creator. DO NOT EDIT MANUALLY.
"""

# flake8: noqa
# type: ignore

import pytest
from sample_functions import *


def test_add_basic():
    """Test add function with basic valid arguments."""
    result = add(a=1, b=2)
    assert result == 3

def test_add_optional_params():
    """Test add function with optional parameters."""
    # This function has no optional parameters, but test is included for illustration
    pytest.skip('Optional parameter test not applicable')

def test_add_edge_cases():
    """Test add function with edge case values for parameters."""
    # Test with various valid/invalid values for int
    # TODO: Add specific edge cases based on type
    pytest.skip('Edge case test needs customization')

def test_subtract_basic():
    """Test subtract function with basic valid arguments."""
    result = subtract(a=10.0, b=3.0)
    assert result == 7.0

def test_subtract_required_params():
    """Test subtract function with required parameters only."""
    result = subtract(a=5.0, b=2.0)
    assert result == 3.0

def test_subtract_optional_params():
    """Test subtract function with optional parameter."""
    pytest.skip('Optional parameter test not applicable')

def test_subtract_edge_cases():
    """Test subtract function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_multiply_basic():
    """Test multiply function with basic valid arguments."""
    result = multiply(a=3, b=4)
    assert result == 12

def test_multiply_required_params():
    """Test multiply function with required parameters only."""
    result = multiply(a=5, b=6)
    assert result == 30

def test_multiply_edge_cases():
    """Test multiply function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_divide_basic():
    """Test divide function with basic valid arguments."""
    result = divide(a=10.0, b=2.0)
    assert result == 5.0

def test_divide_required_params():
    """Test divide function with required parameters only."""
    result = divide(a=10.0, b=2.0)
    assert result == 5.0

def test_divide_raises():
    """Test divide function raises appropriate exceptions for invalid input."""
    with pytest.raises(ZeroDivisionError):
        divide(a=10.0, b=0.0)

def test_divide_edge_cases():
    """Test divide function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_greet_basic():
    """Test greet function with basic valid arguments."""
    result = greet(name="Alice")
    assert result == "Hello, Alice!"

def test_greet_required_params():
    """Test greet function with required parameters only."""
    result = greet(name="Bob")
    assert result == "Hello, Bob!"

def test_greet_edge_cases():
    """Test greet function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_is_even_basic():
    """Test is_even function with basic valid arguments."""
    result = is_even(4)
    assert result is True
    result2 = is_even(5)
    assert result2 is False

def test_is_even_required_params():
    """Test is_even function with required parameters only."""
    result = is_even(2)
    assert result is True

def test_is_even_edge_cases():
    """Test is_even function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_power_basic():
    """Test power function with basic valid arguments."""
    result = power(base=2, exponent=3)
    assert result == 8

def test_power_required_params():
    """Test power function with required parameters only."""
    result = power(base=2)
    assert result == 4

def test_power_optional_exponent():
    """Test power function with optional parameter exponent."""
    result = power(base=3, exponent=4)
    assert result == 81

def test_power_edge_cases():
    """Test power function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_create_message_basic():
    """Test create_message function with basic valid arguments."""
    result = create_message(recipient="bob@example.com")
    assert "To: bob@example.com" in result
    assert "Subject: No Subject" in result

def test_create_message_required_params():
    """Test create_message function with required parameters only."""
    result = create_message(recipient="alice@example.com")
    assert "To: alice@example.com" in result

def test_create_message_optional_subject():
    """Test create_message function with optional parameter subject."""
    result = create_message(recipient="test@example.com", subject="Urgent")
    assert "Subject: Urgent" in result

def test_create_message_optional_body():
    """Test create_message function with optional parameter body."""
    result = create_message(recipient="user@example.com", body="Hello World")
    assert "Hello World" in result

def test_create_message_optional_priority():
    """Test create_message function with optional parameter priority."""
    result = create_message(recipient="x@example.com", priority=1)
    assert "Priority: 1" in result or "priority" in result.lower()

def test_create_message_edge_cases():
    """Test create_message function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_format_name_basic():
    """Test format_name function with basic valid arguments."""
    result = format_name(first="John", last="Doe")
    assert "John" in result and "Doe" in result

def test_format_name_required_params():
    """Test format_name function with required parameters only."""
    result = format_name(first="Jane", last="Smith")
    assert "Jane" in result and "Smith" in result

def test_format_name_optional_middle():
    """Test format_name function with optional parameter middle."""
    result = format_name(first="John", last="Doe", middle="Q")
    assert "John" in result and "Q" in result and "Doe" in result

def test_format_name_optional_title():
    """Test format_name function with optional parameter title."""
    result = format_name(first="Alice", last="Wonder", title="Dr.")
    assert "Dr." in result

def test_format_name_all_params():
    """Test format_name function with all parameters."""
    result = format_name(first="John", last="Doe", middle="Q", title="Dr.")
    assert "Dr." in result and "John" in result and "Q" in result and "Doe" in result

def test_format_name_edge_cases():
    """Test format_name function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_process_numbers_basic():
    """Test process_numbers function with basic valid arguments."""
    result = process_numbers(numbers=[1, 2, 3])
    assert result == [1, 2, 3]

def test_process_numbers_required_params():
    """Test process_numbers function with required parameters only."""
    result = process_numbers(numbers=[1, 2, 3])
    assert result == [1, 2, 3]

def test_process_numbers_optional_multiplier():
    """Test process_numbers function with optional parameter multiplier."""
    result = process_numbers(numbers=[1, 2, 3], multiplier=2)
    assert result == [2, 4, 6]

def test_process_numbers_optional_filter_fn():
    """Test process_numbers function with optional parameter filter_fn."""
    result = process_numbers(numbers=[1, 2, 3, 4, 5], filter_fn=lambda x: x % 2 == 0)
    assert result == [2, 4]

def test_process_numbers_all_params():
    """Test process_numbers function with all parameters."""
    result = process_numbers(numbers=[1, 2, 3, 4], multiplier=10, filter_fn=lambda x: x > 25)
    assert result == [30, 40]

def test_process_numbers_edge_cases():
    """Test process_numbers function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_merge_dicts_basic():
    """Test merge_dicts function with basic valid arguments."""
    result = merge_dicts(dict1={"a": 1}, dict2={"b": 2})
    assert result == {"a": 1, "b": 2}

def test_merge_dicts_required_params():
    """Test merge_dicts function with required parameters only."""
    result = merge_dicts(dict1={"x": 10}, dict2={"y": 20})
    assert "x" in result and "y" in result

def test_merge_dicts_optional_overwrite():
    """Test merge_dicts function with optional parameter overwrite."""
    result = merge_dicts(dict1={"a": 1}, dict2={"a": 2}, overwrite=False)
    assert result["a"] == 1

def test_merge_dicts_overwrite_true():
    """Test merge_dicts function with overwrite=True."""
    result = merge_dicts(dict1={"a": 1}, dict2={"a": 2}, overwrite=True)
    assert result["a"] == 2

def test_merge_dicts_edge_cases():
    """Test merge_dicts function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_calculate_stats_basic():
    """Test calculate_stats function with basic valid arguments."""
    result = calculate_stats(values=[1.0, 2.0, 3.0])
    assert result["mean"] == 2.0
    assert result["min"] == 1.0
    assert result["max"] == 3.0
    assert result["sum"] == 6.0

def test_calculate_stats_empty():
    """Test calculate_stats function with empty list."""
    result = calculate_stats(values=[])
    assert result["mean"] is None
    assert result["min"] is None
    assert result["max"] is None
    assert result["sum"] is None

def test_calculate_stats_edge_cases():
    """Test calculate_stats function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_concat_strings_basic():
    """Test concat_strings function with basic valid arguments."""
    result = concat_strings("hello", " ", "world")
    assert result == "hello world"

def test_concat_strings_varargs():
    """Test concat_strings function with variable positional arguments."""
    result = concat_strings("a", "b", "c", "d")
    assert result == "abcd"

def test_concat_strings_empty():
    """Test concat_strings function with no arguments."""
    result = concat_strings()
    assert result == ""

def test_concat_strings_edge_cases():
    """Test concat_strings function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_sum_all_basic():
    """Test sum_all function with basic valid arguments."""
    result = sum_all(1, 2, 3, 4, 5)
    assert result == 15

def test_sum_all_floats():
    """Test sum_all function with float arguments."""
    result = sum_all(1.5, 2.5, 3.5)
    assert result == 7.5

def test_sum_all_mixed():
    """Test sum_all function with mixed int and float arguments."""
    result = sum_all(1, 2.5, 3)
    assert result == 6.5

def test_sum_all_empty():
    """Test sum_all function with no arguments."""
    result = sum_all()
    assert result == 0

def test_sum_all_edge_cases():
    """Test sum_all function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_create_user_basic():
    """Test create_user function with basic valid arguments."""
    result = create_user(username="alice", email="alice@example.com")
    assert result["username"] == "alice"
    assert result["email"] == "alice@example.com"
    assert result["active"] is True

def test_create_user_required_params():
    """Test create_user function with required parameters only."""
    result = create_user(username="bob", email="bob@example.com")
    assert result["username"] == "bob"
    assert result["email"] == "bob@example.com"

def test_create_user_optional_age():
    """Test create_user function with optional parameter age."""
    result = create_user(username="charlie", email="c@example.com", age=30)
    assert result["age"] == 30

def test_create_user_optional_active():
    """Test create_user function with optional parameter active."""
    result = create_user(username="dave", email="d@example.com", active=False)
    assert result["active"] is False

def test_create_user_kwargs():
    """Test create_user function with additional metadata kwargs."""
    result = create_user(username="eve", email="eve@example.com", role="admin", department="IT")
    assert result["role"] == "admin"
    assert result["department"] == "IT"

def test_create_user_all_params():
    """Test create_user function with all parameters."""
    result = create_user(
        username="frank",
        email="frank@example.com",
        age=25,
        active=True,
        role="user",
        premium=True
    )
    assert result["username"] == "frank"
    assert result["age"] == 25
    assert result["role"] == "user"
    assert result["premium"] is True

def test_create_user_edge_cases():
    """Test create_user function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_call_with_context_basic():
    """Test call_with_context function with basic valid arguments."""
    def sample_func(x, y):
        return x + y
    result = call_with_context(sample_func, 2, 3)
    assert result == 5

def test_call_with_context_required_params():
    """Test call_with_context function with required parameters only."""
    def add(a, b):
        return a + b
    result = call_with_context(add, 1, 2)
    assert result == 3

def test_call_with_context_kwargs():
    """Test call_with_context function with keyword arguments."""
    def greet(name, greeting="Hello"):
        return f"{greeting}, {name}!"
    result = call_with_context(greet, name="World", greeting="Hi")
    assert result == "Hi, World!"

def test_call_with_context_context():
    """Test call_with_context function with context parameter."""
    def sample(x):
        return x * 2
    result = call_with_context(sample, 5, context={"multiplier": 1})
    assert result == 10

def test_call_with_context_edge_cases():
    """Test call_with_context function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_parse_int_basic():
    """Test parse_int function with basic valid arguments."""
    result = parse_int(value="42")
    assert result == 42

def test_parse_int_required_params():
    """Test parse_int function with required parameters only."""
    result = parse_int(100)
    assert result == 100

def test_parse_int_string():
    """Test parse_int function with string input."""
    result = parse_int("  123  ")
    assert result == 123

def test_parse_int_edge_cases():
    """Test parse_int function with edge case values for parameters."""
    with pytest.raises(ValueError):
        parse_int("not a number")

def test_safe_divide_basic():
    """Test safe_divide function with basic valid arguments."""
    result = safe_divide(a=10.0, b=2.0)
    assert result == 5.0

def test_safe_divide_required_params():
    """Test safe_divide function with required parameters only."""
    result = safe_divide(a=10.0, b=5.0)
    assert result == 2.0

def test_safe_divide_optional_default():
    """Test safe_divide function with optional parameter default."""
    result = safe_divide(a=10.0, b=0.0, default=-1.0)
    assert result == -1.0

def test_safe_divide_zero_division():
    """Test safe_divide function with zero divisor and no default."""
    result = safe_divide(a=10.0, b=0.0)
    assert result is None

def test_safe_divide_edge_cases():
    """Test safe_divide function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_first_or_none_basic():
    """Test first_or_none function with basic valid arguments."""
    result = first_or_none(items=[1, 2, 3])
    assert result == 1

def test_first_or_none_required_params():
    """Test first_or_none function with required parameters only."""
    result = first_or_none(items=[10, 20, 30])
    assert result == 10

def test_first_or_none_predicate():
    """Test first_or_none function with predicate parameter."""
    result = first_or_none(items=[1, 2, 3, 4], predicate=lambda x: x > 2)
    assert result == 3

def test_first_or_none_empty():
    """Test first_or_none function with empty list."""
    result = first_or_none(items=[])
    assert result is None

def test_first_or_none_predicate_no_match():
    """Test first_or_none function with predicate that matches nothing."""
    result = first_or_none(items=[1, 2, 3], predicate=lambda x: x > 100)
    assert result is None

def test_first_or_none_edge_cases():
    """Test first_or_none function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_min_max_basic():
    """Test min_max function with basic valid arguments."""
    result = min_max(values=[1, 2, 3, 4, 5])
    assert result == (1, 5)

def test_min_max_required_params():
    """Test min_max function with required parameters only."""
    result = min_max(values=[10, 20, 30])
    assert result == (10, 30)

def test_min_max_floats():
    """Test min_max function with float values."""
    result = min_max(values=[1.5, 2.3, 0.7])
    assert result == (0.7, 2.3)

def test_min_max_empty():
    """Test min_max function raises ValueError on empty list."""
    with pytest.raises(ValueError):
        min_max(values=[])

def test_min_max_single():
    """Test min_max function with single value."""
    result = min_max(values=[42])
    assert result == (42, 42)

def test_min_max_edge_cases():
    """Test min_max function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_partition_basic():
    """Test partition function with basic valid arguments."""
    result = partition(items=[1, 2, 3, 4, 5], predicate=lambda x: x % 2 == 0)
    assert result == ([2, 4], [1, 3, 5])

def test_partition_required_params():
    """Test partition function with required parameters only."""
    result = partition(items=["a", "bb", "ccc"], predicate=lambda s: len(s) > 1)
    assert result == (["bb", "ccc"], ["a"])

def test_partition_all_true():
    """Test partition function with predicate that matches all."""
    result = partition(items=[1, 2, 3], predicate=lambda x: x > 0)
    assert result == ([1, 2, 3], [])

def test_partition_all_false():
    """Test partition function with predicate that matches none."""
    result = partition(items=[1, 2, 3], predicate=lambda x: x < 0)
    assert result == ([], [1, 2, 3])

def test_partition_empty():
    """Test partition function with empty list."""
    result = partition(items=[], predicate=lambda x: x > 0)
    assert result == ([], [])

def test_partition_edge_cases():
    """Test partition function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

# ===== Class Method Tests =====

def test_calculator_basic():
    """Test Calculator class basic usage."""
    calc = Calculator()
    assert calc.value == 0

def test_calculator_initial():
    """Test Calculator class with initial value."""
    calc = Calculator(initial=10)
    assert calc.value == 10

def test_calculator_add():
    """Test Calculator add method."""
    calc = Calculator()
    result = calc.add(5)
    assert result == 5
    assert calc.value == 5

def test_calculator_subtract():
    """Test Calculator subtract method."""
    calc = Calculator(initial=10)
    result = calc.subtract(3)
    assert result == 7
    assert calc.value == 7

def test_calculator_reset():
    """Test Calculator reset method."""
    calc = Calculator(initial=100)
    calc.reset()
    assert calc.value == 0

def test_calculator_from_string():
    """Test Calculator from_string class method."""
    calc = Calculator.from_string("42.5")
    assert calc.value == 42.5

def test_calculator_is_valid_number():
    """Test Calculator is_valid_number static method."""
    assert Calculator.is_valid_number("123") is True
    assert Calculator.is_valid_number("12.3") is True
    assert Calculator.is_valid_number("abc") is False
    assert Calculator.is_valid_number("") is False

def test_calculator_edge_cases():
    """Test Calculator class edge cases."""
    pytest.skip('Edge case test needs customization')

def test_data_processor_basic():
    """Test DataProcessor class basic usage."""
    dp = DataProcessor(data=[1, 2, 3, 4, 5])
    assert dp.data == [1, 2, 3, 4, 5]

def test_data_processor_filter():
    """Test DataProcessor filter method."""
    dp = DataProcessor(data=[1, 2, 3, 4, 5])
    result = dp.filter(lambda x: x % 2 == 0)
    assert result == [2, 4]

def test_data_processor_map():
    """Test DataProcessor map method."""
    dp = DataProcessor(data=[1, 2, 3])
    result = dp.map(lambda x: x * 2)
    assert result == [2, 4, 6]

def test_data_processor_reduce():
    """Test DataProcessor reduce method."""
    dp = DataProcessor(data=[1, 2, 3, 4])
    result = dp.reduce(lambda acc, x: acc + x, 0)
    assert result == 10

def test_data_processor_chain():
    """Test chaining DataProcessor methods."""
    dp = DataProcessor(data=[1, 2, 3, 4, 5])
    result = dp.filter(lambda x: x > 2).map(lambda x: x * 2).reduce(lambda a, b: a + b, 0)
    assert result == 24  # (3*2) + (4*2) + (5*2) = 6+8+10 = 24

def test_data_processor_edge_cases():
    """Test DataProcessor class edge cases."""
    pytest.skip('Edge case test needs customization')

def test_is_positive_basic():
    """Test is_positive function with basic valid arguments."""
    assert is_positive(1) is True
    assert is_positive(0) is False
    assert is_positive(-1) is False

def test_is_positive_float():
    """Test is_positive function with float values."""
    assert is_positive(0.1) is True
    assert is_positive(0.0) is False
    assert is_positive(-0.5) is False

def test_is_positive_edge_cases():
    """Test is_positive function with edge case values."""
    pytest.skip('Edge case test needs customization')

def test_is_empty_basic():
    """Test is_empty function with basic valid arguments."""
    assert is_empty(None) is True
    assert is_empty("") is True
    assert is_empty([]) is True
    assert is_empty({}) is True
    assert is_empty("hello") is False
    assert is_empty([1, 2]) is False

def test_is_empty_required_params():
    """Test is_empty function with required parameters only."""
    assert is_empty([]) is True

def test_is_empty_edge_cases():
    """Test is_empty function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')

def test_fibonacci_basic():
    """Test fibonacci function with basic valid arguments."""
    assert fibonacci(1) == 1
    assert fibonacci(2) == 1
    assert fibonacci(3) == 2
    assert fibonacci(4) == 3
    assert fibonacci(5) == 5

def test_fibonacci_required_params():
    """Test fibonacci function with required parameters only."""
    result = fibonacci(6)
    assert result == 8

def test_fibonacci_zero():
    """Test fibonacci function raises ValueError for n <= 0."""
    with pytest.raises(ValueError):
        fibonacci(0)
    with pytest.raises(ValueError):
        fibonacci(-1)

def test_fibonacci_large():
    """Test fibonacci function with larger n."""
    assert fibonacci(10) == 55

def test_fibonacci_edge_cases():
    """Test fibonacci function with edge case values for parameters."""
    pytest.skip('Edge case test needs customization')
