# EIP-712 签名定义（v0）

本文档定义 v0 使用的 EIP-712 Typed Data 结构。所有签名均用于链上验证与防重放。

## 1. Domain Separator

- `name`: `"AgentMarket"`
- `version`: `"1"`
- `chainId`: `uint256`（使用 `block.chainid`）
- `verifyingContract`: `address`（具体合约地址，如 Marketplace 或 TokenEscrow）

Domain 类型：
```
EIP712Domain(string name,string version,uint256 chainId,address verifyingContract)
```

## 2. Nonce 策略

- 采用 **每个签名者一个单调递增 nonce**：`nonces[signer]`。
- 每条签名消息都包含 `nonce` 字段，必须等于当前 `nonces[signer]`。
- 验证成功后，合约自增 `nonces[signer]`。
- 所有签名类型共用同一 nonce 序列，避免跨类型重放。

## 3. Typed Data 定义

### 3.1 BidSignature
用于代理提交竞标报价的链下签名。

```
BidSignature(
  uint256 jobId,
  address agent,
  uint256 price,
  uint64 eta,
  string bidCID,
  uint256 nonce,
  uint64 deadline
)
```

### 3.2 DeliveryReceiptSignature
用于交付收据确认来源与内容指纹。

```
DeliveryReceiptSignature(
  uint256 escrowId,
  uint256 jobId,
  address agent,
  string deliveryCID,
  bytes32 deliveryHash,
  uint64 timestamp,
  uint256 nonce,
  uint64 deadline
)
```

### 3.3 DisputeEvidenceSignature
用于争议证据提交（买家或代理）。

```
DisputeEvidenceSignature(
  uint256 disputeId,
  uint256 escrowId,
  address submitter,
  string evidenceCID,
  bytes32 evidenceHash,
  uint64 timestamp,
  uint256 nonce,
  uint64 deadline
)
```

## 4. 校验规则（摘要）

- `deadline` 为签名过期时间（Unix 秒），到期后无效。
- 合约应在验证前检查 `nonce` 是否匹配。
- 对于 `string` 字段（CID），按 EIP-712 规则先 `keccak256(bytes(value))` 再参与结构化哈希。

