---
name: ddg-search
description: Search the web using DuckDuckGo. Free, no API key required. Use when the user asks to search the web, look something up, find information online, research a topic, or when you need to find current information that isn't in your training data. Also use when web_search tool is unavailable or has no API key configured.
---

# DuckDuckGo Web Search

Search the web via DuckDuckGo using the `ddgs` Python library. No API key needed.

## Quick Usage

```bash
python3 skills/ddg-search/scripts/search.py "your search query" [count]
```

- `query` (required): Search terms
- `count` (optional): Number of results, default 5, max 20

## Output Format

Each result includes:
- **Title** — Page title
- **URL** — Direct link
- **Snippet** — Text excerpt

## Examples

```bash
# Basic search
python3 skills/ddg-search/scripts/search.py "latest AI news"

# More results
python3 skills/ddg-search/scripts/search.py "Python async tutorial" 10
```

## Follow-up

After searching, use `web_fetch` to read full content from any result URL.

## Dependencies

- `ddgs` Python package (install: `pip install --break-system-packages ddgs`)

## Limitations

- Unofficial scraping — may break if DuckDuckGo changes their frontend
- Rate limits possible under heavy use
- English-biased results by default
