# Negotiation Techniques Reference

Complete breakdown of tactical negotiation techniques from Chris Voss's "Never Split the Difference."

## Table of Contents

1. [Mirroring](#1-mirroring)
2. [Labeling](#2-labeling)
3. [Tactical Empathy](#3-tactical-empathy)
4. [Voice Control](#4-voice-control)
5. [The Power of Apology and Pause](#5-the-power-of-apology-and-pause)
6. [Accusation Audit](#6-accusation-audit)
7. [Calibrated Questions](#7-calibrated-questions)
8. [No-Oriented Questions](#8-no-oriented-questions)
9. [Triggering "That's Right"](#9-triggering-thats-right)
10. [Managing "Yes"](#10-managing-yes)
11. [The Rule of Three](#11-the-rule-of-three)
12. [Re-engagement Technique](#12-re-engagement-technique)
13. [Managing "Fair"](#13-managing-fair)
14. [Anchoring and Loss Aversion](#14-anchoring-and-loss-aversion)
15. [Ackerman Bargaining Method](#15-ackerman-bargaining-method)
16. [Leverage Types](#16-leverage-types)
17. [Black Swans](#17-black-swans)
18. [Counterpart Styles](#18-counterpart-styles)
19. [Body Language and Tone](#19-body-language-and-tone)
20. [Dynamic Silence](#20-dynamic-silence)
21. [Pronoun Analysis](#21-pronoun-analysis)

---

## 1. Mirroring

**What it is:** Repeat the last 1-3 critical words your counterpart said, using a curious, upward-inflecting tone.

**Psychological trigger:** Creates familiarity and rapport; signals deep listening; prompts elaboration without direct questions.

**How to use:**
- Listen for the key phrase or emotion-laden words
- Repeat them back as a gentle question
- Wait silently for them to expand

**Example:**
> Counterpart: "We're not sure if this partnership makes sense."
> You: "Doesn't make sense?"
> Counterpart: "Well, what I mean is... [elaborates on concerns]"

---

## 2. Labeling

**What it is:** Identify and verbalize the counterpart's emotions or perspective using neutral phrases: "It seems like...", "It sounds like...", "It looks like..."

**Psychological trigger:** Validates emotions, making them feel understood. Diffuses negative emotions by naming them; reinforces positive ones.

**How to use:**
- Observe their emotional state or concerns
- Name it with a tentative label (avoid "I think you...")
- Pause after labeling to let them confirm or clarify

**Examples:**
> "It seems like you're worried about the budget impact."
> "It sounds like there's been some frustration with the timeline."
> "It looks like this decision carries a lot of weight for your team."

**Important:** After labeling, be silent. Let them respond.

---

## 3. Tactical Empathy

**What it is:** Consciously imagining yourself in their situation and vocalizing their perspective. Combines the mindset of sincere empathy with techniques like mirroring and labeling.

**Psychological trigger:** When people feel understood, brain chemistry shifts toward trust and cooperation. Empathy short-circuits defensive reactions.

**How to use:**
- Before responding, ask yourself: "What is their world like right now?"
- Articulate their situation, pressures, and fears
- Show you understand even if you disagree

**Example:**
> "I understand you're under enormous pressure to deliver this quarter, and bringing in a new vendor feels like adding risk to an already difficult situation."

**Key insight:** Empathy is not agreement. You can understand their position while still advocating for your own needs.

---

## 4. Voice Control

### Late-Night FM DJ Voice
- **When:** Critical moments, delivering key statements, de-escalating tension
- **How:** Slow, calm, deep, downward inflection at sentence ends
- **Effect:** Exudes confidence and calm; relaxes their brain, making them more receptive

### Positive/Playful Voice
- **When:** Default mode; building rapport; most of the conversation
- **How:** Friendly, warm, light-hearted, with a genuine smile
- **Effect:** Signals comfort and likability; encourages cooperation

**Key insight:** Never use a high-pitched or rapid voice in negotiations—it signals anxiety or aggression.

---

## 5. The Power of Apology and Pause

**What it is:** Start difficult statements with "I'm sorry..." in a slow, calm tone, then deliberately pause for 4+ seconds.

**Psychological trigger:** Apology disarms hostility; silence creates a vacuum the other person feels compelled to fill.

**Sequence:**
1. "I'm sorry..." (slow, sincere)
2. Mirror or label their situation
3. Silence (4+ seconds)

**Example:**
> "I'm sorry... It looks like I've let you down on this project." (Pause)
> Counterpart: "No, it's not just you... the timing caught us off guard..."

---

## 6. Accusation Audit

**What it is:** Before negotiating, list and preemptively verbalize every negative thing they might think or say about you.

**Psychological trigger:** Naming fears and criticisms before they do removes their power. Often triggers reassurance ("Oh, I don't think that...") or at least neutralizes objections.

**How to use:**
1. Before the meeting, brainstorm: What negatives might they think about me/my position?
2. Early in the conversation, acknowledge these directly
3. Watch them relax as you've addressed the elephant in the room

**Example:**
> "You probably think I'm being greedy. You may feel like I haven't listened to you in the past. And it might seem like I only care about my own interests. I understand why you might feel that way, and I want to address those concerns..."

---

## 7. Calibrated Questions

**What it is:** Open-ended "How...?" and "What...?" questions that shape the conversation while giving them the illusion of control.

**Psychological trigger:** Engages their problem-solving mind; makes them feel in control while you direct the conversation; avoids defensiveness that "Why?" creates.

**Formula:**
- Start with "How" or "What"
- Make it neutral and collaborative
- Avoid "Why" (sounds accusatory)

**Power questions:**
| Question | Purpose |
|----------|---------|
| "How am I supposed to do that?" | Pushes back without saying no |
| "What's the biggest challenge you're facing?" | Uncovers hidden needs |
| "What about this is important to you?" | Reveals value drivers |
| "How can we make this work?" | Creates collaboration |
| "What would it take to make this happen?" | Identifies obstacles |
| "How does this affect your team?" | Shows empathy, gathers intel |

**Exception for "Why":** Only use when you want them to defend something favorable to you: "Why would you ever choose our company?" (Makes them articulate your strengths.)

---

## 8. No-Oriented Questions

**What it is:** Questions designed to elicit "No" rather than "Yes," because "No" makes people feel safe and in control.

**Psychological trigger:** Saying "No" satisfies the human need for autonomy and control. Once they've said no, they relax and engage more openly.

**How to frame:**
- Instead of "Do you agree?", ask "Would it be unreasonable to...?"
- Instead of "Can we move forward?", ask "Are you against trying this?"

**Tactical mislabeling:** Intentionally state something false to prompt a corrective "No":
> "It seems like you've given up on this project?"
> Counterpart: "No, I haven't given up. I'm just frustrated with the delays."

Now you have their real concern.

---

## 9. Triggering "That's Right"

**What it is:** Summarize their position—their facts, emotions, and concerns—so accurately that they respond with "That's right."

**Psychological trigger:** "That's right" signals complete understanding and creates genuine rapport. It's the moment they feel truly heard.

**How to earn it:**
1. Listen deeply throughout the conversation
2. Paraphrase their main points, including emotional subtext
3. Deliver as a summary: "Let me make sure I understand..."
4. Keep refining until you get "That's right"

**Example:**
> "Let me make sure I have this: You need a solution that doesn't overrun budget, and you're concerned that our timeline could put your team in a tough spot. On top of that, you've been burned by vendors who overpromised before."
> Counterpart: "That's right."

**Warning:** "You're right" is different—it often means they're dismissing you. Keep working until you get "That's right."

---

## 10. Managing "Yes"

**Three types of yes:**

| Type | What it means | How to detect |
|------|---------------|---------------|
| **Counterfeit Yes** | Saying yes to escape or appease | Quick, no follow-through |
| **Confirmation Yes** | Agreeing to a minor point | "Yes, I received the email" |
| **Commitment Yes** | True agreement with intent to act | Detailed, enthusiastic |

**Key insight:** Only commitment yes matters. Chasing yes makes people defensive.

**Strategy:** Instead of pushing for yes, make them comfortable saying no first. Once they've said no (and you've addressed it), their eventual yes is more likely to be genuine.

---

## 11. The Rule of Three

**What it is:** Get them to affirm the agreement three times, in three different ways, within the same conversation.

**Psychological trigger:** Genuine agreements withstand multiple confirmations. If it falls apart on round two or three, you didn't really have a deal.

**How to apply:**
1. First yes: Direct agreement
2. Second yes: Summarize and get "That's right"
3. Third yes: Calibrated question about implementation: "How will your team handle...?"

**Example sequence:**
> "So we're agreed on the $50K budget?" → "Yes."
> "Just to make sure I understand—you'll allocate $50K with delivery in Q3?" → "That's right."
> "Great. How will you communicate this to your finance team?" → "I'll send them the PO tomorrow."

---

## 12. Re-engagement Technique

**What it is:** When someone goes silent (email, text, or in person), ask: "Have you given up on [this project/deal]?"

**Psychological trigger:** People hate being seen as quitters. This question triggers an instinctive "No" and forces them to re-engage and explain.

**When to use:**
- Unresponsive counterpart
- Stalled negotiations
- Ghosting behavior

**Example:**
> Subject: Quick question
> "Have you given up on the partnership we discussed?"
>
> Response: "No, I haven't given up. I've just been slammed with..."

---

## 13. Managing "Fair"

**The word "fair" can derail negotiations. Three scenarios:**

### Scenario 1: "We just want what's fair"
- **What they mean:** Making you feel guilty; implying you've been unfair
- **Response:** "Absolutely, I want to be fair too. Let's pause—have I done something unfair? Let's talk about it."

### Scenario 2: "This is a fair offer"
- **What they mean:** Anchoring; don't ask for more
- **Response:** Mirror: "Fair?" (silence). Then: "How did you arrive at that figure?"

### Scenario 3: Preempt it yourself
- **What to say:** "My goal is for you to feel this is 100% fair. If at any point you don't, please tell me and we'll address it."
- **Effect:** Removes "fair" as a future weapon

---

## 14. Anchoring and Loss Aversion

### Anchoring
**What it is:** The first number mentioned skews all subsequent discussion.

**How to use:**
- If selling: Start high (higher than you expect to get)
- If buying: Start low
- Use ranges to anchor softly: "Similar projects run $150K-$250K" (your target is $150K)

### Loss Aversion
**What it is:** People will take greater risks to avoid losses than to achieve gains.

**How to use:**
- Emphasize what they lose by not agreeing
- Frame the cost of inaction, not just the benefit of action

**Example:**
> "If we don't resolve this now, you'll lose three months of runway and the team's momentum."

### Deadlines
- Question every deadline: "Whose deadline is it? Is it real?"
- Don't let artificial deadlines rush you into bad deals
- Use legitimate deadlines strategically to create urgency

---

## 15. Ackerman Bargaining Method

Step-by-step monetary negotiation system:

| Step | Action | Rationale |
|------|--------|-----------|
| 1 | Set your target price | Your real goal |
| 2 | Open at **65%** of target | Extreme but not insulting anchor |
| 3 | First raise to **85%** | Decreasing increment signals limit |
| 4 | Second raise to **95%** | Even smaller—they feel they're squeezing you |
| 5 | Final offer at **100%** | Use precise number ($97,350 not $97,000) |
| 6 | Add non-monetary item | "...and I'll include a 1-year warranty" |

**Why precise numbers work:** Non-round numbers ($47,235 vs $47,000) feel calculated and final—as if you've truly pushed to your limit.

**Why the final gift:** A small non-monetary add-on signals you're at your absolute maximum and makes it psychologically harder for them to ask for more.

---

## 16. Leverage Types

Leverage is power in negotiation—often perception, not reality.

| Type | Definition | How to use |
|------|------------|------------|
| **Positive** | You have something they want | Remind them of what they gain by dealing with you |
| **Negative** | You can cause them pain | Mention consequences of no deal (use carefully) |
| **Normative** | Using their beliefs/values against them | "You've always said quality matters most—would cutting corners align with that?" |

**Key question:** "Who feels they have more to lose if this falls apart?"

**Insight:** Even without objective power, you can create perceived leverage by uncovering what they fear or desperately want.

---

## 17. Black Swans

**What they are:** Hidden, game-changing pieces of information that can transform a negotiation once discovered.

**Assumption:** Every negotiation has approximately 3 Black Swans lurking.

**Types of Black Swans:**
- Secret constraints (their boss said no more than X)
- Hidden motivations (they need this deal to save their job)
- Unknown context (their competitor just made a move)

**How to find them:**
- Stay curious; ask calibrated questions
- Use tactical empathy to make them comfortable
- Watch for anomalies—odd reactions signal hidden factors
- Listen in unguarded moments (before/after meetings)

**Effect:** Discovering a Black Swan can turn a stalemate into a breakthrough.

---

## 18. Counterpart Styles

### Analyst
- **Traits:** Methodical, data-driven, prizes accuracy, hates surprises, may seem cold
- **Fears:** Being rushed, making errors, being unprepared
- **Adapt:** Use data and facts, be patient, give them time to process, don't pressure with tight deadlines

### Accommodator
- **Traits:** Amiable, relationship-focused, values personal connection, avoids conflict
- **Fears:** Confrontation, damaging relationships
- **Adapt:** Build rapport, make small talk, be friendly—but ensure you pin down specifics (they may agree too quickly just to please)

### Assertive
- **Traits:** Direct, time-conscious, wants to win, speaks fast, comfortable saying no
- **Fears:** Wasting time, being seen as weak
- **Adapt:** Be efficient, stand your ground, acknowledge their points, frame proposals as wins for them

**Insight:** Great negotiators borrow from all three styles as needed.

---

## 19. Body Language and Tone

**The 7-38-55 Rule:**
- 7% of meaning: Words
- 38% of meaning: Tone
- 55% of meaning: Body language

**What to watch:**
- Incongruence between words and tone/body (signals hesitation or deception)
- Arms crossed, leaning back (defensive)
- Leaning in, open posture (engaged)
- Facial micro-expressions

**When to observe:** Unguarded moments before/after meetings reveal true feelings.

**Your own signals:**
- Keep body language open (no crossed arms, no pointing)
- Nod to show listening
- Maintain appropriate eye contact
- Smile genuinely

---

## 20. Dynamic Silence

**What it is:** Deliberate, extended pauses after key statements or questions.

**Psychological trigger:** Silence creates a vacuum people instinctively fill—often with information, concessions, or their internal reasoning.

**How to use:**
- Make your statement or ask your question
- Stop talking completely
- Maintain calm, attentive presence
- Resist the urge to fill the silence yourself

**Effect:**
- They reveal more information
- They may negotiate against themselves
- Your words carry more weight

**Rule:** "He who speaks least often wins."

---

## 21. Pronoun Analysis

**What to listen for:**

| Pronoun pattern | What it may indicate |
|-----------------|---------------------|
| Heavy "I/me/my" | May lack full authority; someone else decides |
| "We/they/our team" | Decision-maker or representing group consensus |
| Shift from "I" to "we" | May be invoking higher authority to deflect |

**How to use this:**
- If they use "I" heavily, ask: "How does your team/leadership weigh in on this?"
- If they use "we" heavily, they may have authority—but verify

**Humanize yourself:** Use your name and their name throughout. "Look, Sarah, I really want to make this work" is more disarming than "I want to make this work."
