---
name: negotiation
description: Tactical negotiation framework based on Chris Voss's "Never Split the Difference." Use when preparing for negotiations, during live negotiation scenarios, analyzing counterpart behavior, crafting responses to difficult conversations, handling objections, salary/contract negotiations, or when asked about negotiation techniques like mirroring, labeling, calibrated questions, or the Ackerman method.
license: MIT
metadata:
  author: wondelai
  version: "1.0.0"
---

# Negotiation

Tactical empathy-based negotiation framework from FBI hostage negotiator Chris Voss.

## Core Mindset

1. **People want to be understood** - Satisfy their need to feel safe and in control through active listening
2. **Listen to discover, not to argue** - Treat assumptions as hypotheses; let them reveal surprises
3. **Focus on needs, not positions** - Tangible demands mask emotional needs (respect, security, autonomy)
4. **Never split the difference** - No deal is better than a bad deal; avoid lukewarm compromises
5. **"No" is the starting point** - "No" means "not yet" or "not this way"; it makes people feel safe
6. **Aim for "That's right"** - Better than "yes"; signals genuine rapport and understanding
7. **Stay calm and positive** - Emotions are contagious; slow pace enables clear thinking
8. **Unconditional positive regard** - Respect them as a person regardless of disagreement

## Quick Reference: Key Techniques

| Technique | What to do | Example |
|-----------|------------|---------|
| **Mirroring** | Repeat last 1-3 words with upward inflection | "Doesn't make sense?" |
| **Labeling** | Name their emotion: "It seems like..." | "It sounds like you're frustrated with the timeline" |
| **Calibrated Questions** | Ask "How...?" or "What...?" to shape conversation | "How am I supposed to do that?" |
| **Accusation Audit** | Preemptively list negatives they might think | "You probably think I'm being greedy..." |
| **Late-Night DJ Voice** | Slow, calm, downward inflection for key moments | Deep, reassuring tone |
| **Tactical Silence** | Pause 4+ seconds after statements | Let them fill the void |
| **Trigger "That's Right"** | Summarize their position until they affirm | "So what you're saying is..." |

For detailed technique breakdowns with psychological triggers and examples, see [references/techniques.md](references/techniques.md).

## Negotiation Workflow

### Phase 1: Preparation

1. Research the counterpart (background, pressures, constraints)
2. Define your goal and BATNA (Best Alternative to Negotiated Agreement)
3. Prepare an **Accusation Audit** - list every negative they might think about you
4. Draft 3-5 **Calibrated Questions** to uncover their needs
5. Identify potential **Black Swans** (hidden information that could change everything)

### Phase 2: Opening

1. Use friendly, positive tonality as default
2. Start with **Tactical Empathy** - demonstrate you understand their situation
3. Deliver your **Accusation Audit** early to defuse objections
4. Encourage them to say "No" - it makes them feel safe and in control

### Phase 3: Information Gathering

1. **Mirror** key phrases to encourage elaboration
2. **Label** emotions as they emerge ("It seems like...")
3. Ask **Calibrated Questions** ("What's the biggest challenge here?")
4. Listen for pronouns: "I/me" suggests less authority; "we/they" suggests decision-maker
5. Watch for **Black Swans** - anomalies that reveal hidden constraints

### Phase 4: Bargaining

For monetary negotiations, use the **Ackerman Method**:

1. Set your target price (what you actually want)
2. Open at **65%** of target
3. Raise in decreasing increments: **85%** → **95%** → **100%**
4. Use **precise, non-round numbers** on final offer ($10,230 not $10,000)
5. Include a **non-monetary bonus** with final offer ("...and I'll include X")

### Phase 5: Closing

1. Get **"That's Right"** before proposing solutions
2. Apply **Rule of Three** - confirm agreement 3 times in 3 different ways
3. Follow every "yes" with "How...?" to ensure implementation
4. If they go silent, ask: "Have you given up on this?"

## Handling Common Situations

**They say "That's not fair":**
- Stop immediately: "I want to be fair. Have I done something unfair? Let's discuss it."

**They anchor with an extreme number:**
- Don't counter immediately; use calibrated questions: "How did you arrive at that figure?"

**They stop responding:**
- Send: "Have you given up on [the project]?" - triggers "No" response

**They seem irrational:**
- Diagnose: Are they (1) ill-informed, (2) constrained, or (3) hiding something?
- Use calibrated questions to uncover which

## Counterpart Styles

Adapt your approach based on their style:

| Style | Signs | Adapt by... |
|-------|-------|-------------|
| **Analyst** | Methodical, data-driven, hates surprises | Use facts, be patient, don't rush |
| **Accommodator** | Friendly, relationship-focused, avoids conflict | Build rapport, but pin down specifics |
| **Assertive** | Direct, time-conscious, wants to win | Be efficient, stand firm, acknowledge their points |

## Voice and Delivery

- **Default voice**: Positive, warm, light-hearted (with a smile)
- **Critical moments**: Late-Night DJ Voice - slow, calm, downward inflection
- **After key statements**: Pause 4+ seconds
- **Watch their nonverbals**: 7% words, 38% tone, 55% body language

## Resources

- [techniques.md](techniques.md) - Complete technique breakdowns with examples and psychological triggers
