---
name: negotiation
description: Navigate negotiations as a solopreneur — pricing, scope, terms, and contracts. Use when a prospect pushes back on price, wants to change scope, disputes terms, or when you need to structure a deal that works for both sides. Covers negotiation psychology, common objection responses, BATNA (Best Alternative To a Negotiated Agreement), anchoring, and solopreneur-specific scenarios like rate negotiations and contract terms. Trigger on "negotiate", "negotiation", "they want a discount", "price pushback", "contract negotiation", "how to negotiate", "client wants lower price", "negotiate terms".
---

# Negotiation

## Overview
Negotiation is not arguing. It is a structured conversation where both parties try to find an arrangement that works. For solopreneurs, negotiation skill directly impacts both your revenue and your stress — a good negotiation ends with a fair deal and a happy client. A bad one ends with resentment on both sides. This playbook gives you the frameworks and scripts to negotiate confidently, even if it feels uncomfortable.

---

## Step 1: Know Your BATNA Before Every Negotiation

BATNA = Best Alternative To a Negotiated Agreement. It's what you'll do if this deal falls through. Knowing your BATNA gives you power — it tells you the minimum you should accept and gives you confidence to walk away if needed.

**Before any negotiation, write down:**
```
If this deal doesn't happen, I will: [specific alternative]
The minimum deal I would accept: $_______ (price) with _______ (terms)
My walk-away point: anything below _______ or with terms worse than _______
```

**Example:**
```
If this deal doesn't happen, I will: pursue 3 other leads already in my pipeline
Minimum acceptable: $3,500 for the project, Net-30 payment terms
Walk-away: anything below $2,800 or requiring more than 3 revision rounds
```

**The stronger your BATNA, the stronger your negotiation position.** If you have zero other prospects, you'll accept bad terms out of desperation. If you have a full pipeline, you can walk away from a bad deal without panic. This is why pipeline building (see outreach-and-prospecting) is negotiation preparation.

---

## Step 2: Understand the Psychology at Play

Negotiation is partly rational (numbers, terms) and partly psychological (perception, framing, emotion). Know these principles and use them:

**Anchoring:** The first number stated in a negotiation becomes the reference point. Everything after is measured against it. This is why you should name your price first (from your proposal), not wait for them to name theirs. Your price anchors the conversation.

**Reciprocity:** People feel obligated to return favors. If you offer a concession first (a small discount, an added feature, flexible payment terms), they feel pressure to meet you halfway. Use this intentionally — offer small things to get larger things.

**Loss aversion:** People feel the pain of losing something more intensely than the pleasure of gaining something equivalent. Frame your value in terms of what they'll LOSE by not working with you, not just what they'll GAIN: "Without this, your team continues to waste 15 hours/week — that's $X/month in lost productivity."

**Social proof in negotiation:** If you mention that other clients in similar situations paid similar prices and got great results, it normalizes your pricing. "Other [industry] clients I've worked with found this price point very reasonable given the ROI they saw."

---

## Step 3: Handle the Most Common Objections

These are the objections you will hear repeatedly. Have a response ready for each.

### "That's more than we budgeted."
**Response approach:** Don't immediately discount. Explore first.
```
"I appreciate you being upfront about that. Help me understand — what 
budget range were you working with? I want to see if there's a way to 
structure this that works for both of us."
```
Then: adjust scope (not price) to fit their budget. Offer a phased approach — Phase 1 at their budget, Phase 2 later. Or offer a payment plan (monthly instead of upfront).

**Never discount just because they asked.** Discounting without a reason trains them to always ask.

### "Can you do it cheaper?"
**Response approach:** Ask what they'd be willing to give up.
```
"Absolutely, I can look at ways to bring the price down. To do that, 
I'd need to reduce the scope. What's the piece that matters least to you? 
I can cut that and give you a revised number."
```
This reframes the conversation from "lower your price" to "what are you willing to trade?" Most of the time, they don't actually want to cut scope — they just wanted to test whether your price was firm.

### "We found a cheaper option."
**Response approach:** Don't panic. Don't match the price. Differentiate.
```
"That's good to know. I'd encourage you to look closely at what's 
included — in my experience, lower prices in this space usually mean 
less customization, slower delivery, or less support. What matters 
most to you in this engagement?"
```
Then show how your price maps to the specific outcomes they care about. If they still choose the cheaper option, let them go gracefully — they may come back when the cheaper option underdelivers.

### "We need more time to decide."
**Response approach:** Understand the real reason, then address it.
```
"Of course — what's driving the timeline? Is there something specific 
you'd like to see or discuss before you're comfortable moving forward? 
I want to make sure you feel fully confident in this decision."
```
Often "need more time" means "I have an unspoken concern." Surface it and address it directly.

### "Can you add [scope item] at no extra cost?"
**Response approach:** Never add scope for free without getting something in return.
```
"I can definitely look into that. That would add about [X hours] of work, 
so I'd need to either add [small amount] to the price, or we could swap it 
for [something currently in scope that's less critical]. What would you 
prefer?"
```
This teaches them that scope changes have a cost — a healthy professional boundary.

---

## Step 4: Structure the Negotiation Conversation

When you're in an active negotiation (call, email, or in person), follow this structure:

**1. Understand first (listen 60%, talk 40%)**
Before proposing anything, make sure you understand their constraints and priorities. Ask open-ended questions: "What's most important to you in this decision?" "What does your timeline look like?" "What would make this an easy yes for you?"

**2. State your position clearly and with confidence**
Don't apologize for your price. Don't hedge. Say it clearly: "Based on the scope we discussed, my price is $X. Here's what that includes and why."

**3. Trade concessions, don't give them away**
Every concession you make should come with something in return. "I can drop the price by $500 if we move the timeline up by one week" or "I can include the extra feature if you commit to a 6-month contract instead of 3."

**4. Know when to close**
When you sense agreement is close, name it: "It sounds like we're aligned on the scope and price. Shall I send over the contract?" Don't keep negotiating after the deal is essentially done — that's how you lose it.

**5. Know when to walk away**
If they want terms that are below your walk-away point, say so calmly: "I appreciate the conversation, but at that price point I wouldn't be able to deliver the quality you deserve. I'd rather be honest about that now than overpromise and underdeliver. If your budget opens up in the future, I'd love to revisit."

---

## Step 5: Negotiate in Writing When Possible

Written negotiations (email) have advantages for solopreneurs:
- Everything is documented. No "but you said..." disputes later.
- You have time to think before responding. No pressure to answer on the spot.
- You can be more precise with numbers and terms.

**When a negotiation moves to a call:** Follow up with an email summarizing what was discussed and agreed upon. "Per our call, here's what we agreed: [list]. Let me know if I've captured everything correctly."

---

## Step 6: Contract Terms to Negotiate (or Protect)

When it comes time to sign, these are the terms that matter most for solopreneurs. Know your position on each before the conversation starts:

| Term | Your Goal | Red Flag |
|---|---|---|
| Payment timing | 50% upfront, 50% on delivery. Or Net-15. | Net-60 or "payment on completion" with no upfront |
| Scope changes | Any change requires written approval and revised pricing | Open-ended "as needed" changes |
| IP ownership | You retain ownership unless explicitly sold | Blanket "we own everything you create" |
| Termination clause | 30-day notice from either side | They can terminate instantly with no payment for work done |
| Liability cap | Limited to the contract value | Unlimited liability |
| Non-compete | No non-compete, or very narrow (same client only) | Broad non-compete blocking you from working in your industry |

---

## Negotiation Mistakes to Avoid
- Negotiating against yourself. Don't offer a discount before they ask for one. Present your price with confidence and let them respond.
- Being afraid of silence. After you state your price, don't fill the silence. Let them think. The first person to speak after a number is stated often makes a concession.
- Treating negotiation as adversarial. It's collaborative. You both want a deal that works. Approach it as problem-solving, not combat.
- Caving on price when the real issue is something else (timeline, scope, trust). Diagnose before you discount.
- Forgetting to get everything in writing. Verbal agreements are worth nothing if there's a dispute later.
