# Selling Negotiations

## Context
Selling services (freelance, consulting) or products. Protecting value while closing deals.

## Floor Prices

Define before any negotiation:
- **Minimum acceptable** — below this, walk away
- **Target price** — what you actually want
- **Premium price** — for rush/complexity/difficult clients

Formula for services: `(Annual target ÷ billable hours) × 1.3 = floor`

## Handling "Too Expensive"

Never immediately drop price. Try:

1. **Ask what they had in mind** — understand their constraint
2. **Unbundle** — "I can do X for €800, without Y"
3. **Reframe value** — "This includes Z which typically costs €500 alone"
4. **Future discount** — "Full price now, 10% off next project"

## Scope Creep Defense

When they ask for more:
- Acknowledge the request positively
- Quote additional cost immediately
- "Happy to add that — it's €X extra, or we can swap out Y"

Track all concessions. If you've already given something free, don't give more.

## Closing Signals

| Signal | Action |
|--------|--------|
| "How do we proceed?" | Stop negotiating, close |
| Asking about timeline/logistics | They're buying — finalize |
| Repeated small objections | Address, then ask for decision |
| Silence after your offer | Wait — don't fill the gap |

## Anchoring & Packaging

- Present premium option first (anchor high)
- Standard option feels reasonable by comparison
- Bundle related services: maintenance, support, revisions

## Escalation Triggers

Always escalate to principal:
- Deal above €X (set threshold)
- Client wants unusual payment terms
- Scope significantly larger than quoted
- Any red flags about client reliability
