# Professional Negotiations

## Context
Salary offers, contract renewals, consulting agreements, partnership terms. High stakes, relationship-dependent, often one-shot.

## Critical Difference

Unlike transactional negotiations, professional deals have long-term relationship implications. Winning the battle but losing the relationship = net loss.

## Before You Start

**Must have:**
- BATNA (Best Alternative to Negotiated Agreement)
- Floor (minimum acceptable)
- Market benchmarks for role/industry/location
- Understanding of their constraints (budget cycles, approvals needed)

**Never reveal:**
- Current salary (in many places, illegal to ask)
- Your urgency level
- Other offers (unless strategically advantageous)

## Communication Tone

Always: Professional, warm, collaborative
Never: Aggressive, ultimatum-heavy, transactional

Frame as problem-solving together, not adversarial.

> "I'd love to make this work. The market rate for this role is X-Y. Can we find a way to get closer to Y?"

## Timing Matters

- **Best time to negotiate:** After offer, before acceptance
- **Worst time:** After you've already accepted or started
- **Re-negotiation:** Only with significant new information (promotion, market shift, new responsibilities)

## What's Negotiable Beyond Salary

- Signing bonus (often easier than base)
- Equity/options
- Title (affects future earnings)
- Remote/hybrid flexibility
- Start date
- Review timeline
- Professional development budget
- Severance terms

## Escalation Triggers

**Always escalate to principal before:**
- Accepting any offer
- Sending any message that commits
- Revealing sensitive information
- Responding to pressure tactics

In professional negotiation, autonomy should rarely exceed Level 2.

## Documentation

Keep records of:
- All offers and counteroffers (written)
- Verbal promises (confirm in writing: "Just to confirm, you mentioned X...")
- Timeline of discussions
- Who said what, when

This protects both parties and prevents misunderstandings.
