# Stress Management and Wellbeing

## Why Wellbeing Matters for NEET

- NEET preparation is a marathon (1-2 years)
- Burnout destroys more aspirants than lack of ability
- Mental health directly affects memory and problem-solving
- Physical health affects energy and focus

## Burnout Warning Signs

### Early Signs (Intervene Now)
- Difficulty concentrating for usual duration
- Feeling tired despite adequate sleep
- Irritability with family/friends
- Procrastination increasing
- "What's the point" thoughts creeping in

### Serious Signs (Immediate Action Needed)
- Crying spells or emotional outbursts
- Physical symptoms (headaches, stomach issues)
- Sleep problems (insomnia or oversleeping)
- Complete loss of motivation
- Thoughts of giving up entirely

### What to Do
| Severity | Action |
|----------|--------|
| Early | 1-2 day break, reduce hours by 20% |
| Moderate | Week of lighter study, talk to someone |
| Serious | Professional help, consider timeline adjustment |

## Daily Wellbeing Practices

### Non-Negotiables
1. **7-8 hours sleep** — Memory consolidation happens during sleep
2. **3 meals** — Brain needs glucose; don't skip meals
3. **30 min physical activity** — Walk, yoga, sport—anything
4. **10 min outdoors** — Sunlight regulates circadian rhythm
5. **1 non-study activity** — Talk to friend, watch something, hobby

### Quick Stress Relievers
- **4-7-8 breathing** — Inhale 4s, hold 7s, exhale 8s (3 cycles)
- **Progressive muscle relaxation** — Tense and release each muscle group
- **5-minute walk** — Physical movement resets mental state
- **Call someone** — Social connection reduces cortisol

## Comparison and Social Media

### The Comparison Trap
- "Everyone is studying more than me"
- "XYZ got 650 in mock and I'm at 550"
- "That coaching topper studies 16 hours"

### Reality Check
- Social media shows highlight reels, not struggles
- Coaching institutes promote toppers, not average students
- Your only competition is your past self
- 700k students take NEET; most don't post their scores

### Digital Hygiene
- **Mute** NEET-related groups (check once daily)
- **Unfollow** accounts that make you feel inadequate
- **Time limit** social media to 30 min/day
- **No phone** during study blocks

## Sleep Optimization

### The Science
- REM sleep consolidates learned information
- Deep sleep repairs body and mind
- Sleep deprivation = worse than being drunk for cognition

### Sleep Schedule
- **Fixed wake time** — Even weekends (±30 min)
- **Wind down** — No screens 1 hour before bed
- **Dark room** — Melatonin needs darkness
- **No studying in bed** — Bed = sleep only

### If You Can't Sleep
- Don't lie awake more than 20 min
- Get up, do something boring (not phone)
- Return when sleepy
- Don't check the time repeatedly

## Exam Anxiety Management

### Before Exam (Days/Weeks)
- **Mock exams** — Familiarity reduces anxiety
- **Exam day simulation** — Wake time, travel, timing
- **Backup plans** — What if traffic? What if forgot pen?
- **Positive visualization** — Imagine successful completion

### Day Before Exam
- **Light revision only** — Flashcards, notes
- **No new topics** — You won't learn anything new
- **Pack everything** — Admit card, ID, stationery
- **Early sleep** — Aim for 7+ hours

### During Exam
- **If panic hits** — Stop, breathe 10 times, continue
- **Stuck on question** — Mark and move (come back later)
- **Don't look at others** — Focus on your paper
- **Hydrate** — Water helps concentration

### After Exam
- **Don't discuss answers** — It changes nothing, only causes stress
- **Avoid social media** — Answer key debates are toxic
- **Rest** — You earned it
- **Next steps** — Plan counselling preparation

## Family and Social Support

### For Students
- **Communicate** — Tell parents when you're struggling
- **Set boundaries** — "I need quiet from 6-10 PM"
- **Ask for help** — Healthy meals, minimal chores
- **Don't isolate** — Regular family meals matter

### For Parents (Reading This)
- **Don't ask "kitna padha?"** — Ask "how are you feeling?"
- **Reduce pressure** — Your anxiety transfers to them
- **Trust the process** — Micro-managing doesn't help
- **Celebrate effort** — Not just mock scores
- **Have backup plans** — Reduces everyone's anxiety

## When to Seek Help

### Talk to Someone If
- Feeling hopeless for more than a few days
- Can't eat or sleep properly for a week+
- Thoughts of self-harm (even fleeting)
- Physical symptoms without physical cause
- Panic attacks becoming frequent

### Resources
- **School counselor** — Often free and accessible
- **iCall**: 9152987821 (TISS counselling)
- **Vandrevala Foundation**: 1860-2662-345
- **NIMHANS**: 080-46110007

### Remember
- Seeking help is strength, not weakness
- Many NEET aspirants struggle; you're not alone
- One exam doesn't define your worth
- There are many paths to becoming a doctor
