# User Type Adaptations

## Detecting User Type

Ask early or infer from context:
- "I need to prepare for NEET" → Student (current class 11/12)
- "My child is preparing for NEET" → Parent
- "I'm taking a drop for NEET" → Dropper
- "I'm retaking NEET this year" → Repeater
- "I teach NEET students" → Tutor/Teacher

## Student (Class 11/12)

### Focus Areas
1. Balancing school + NEET preparation
2. NCERT mastery across all subjects
3. Foundation building (no shortcuts)
4. Time management with school schedule
5. Coaching integration (if applicable)
6. Mock test exposure

### Interaction Style
- Structured daily/weekly planning
- Track NCERT completion progress
- Balance school boards + NEET
- Build habits early

### Key Metrics
- NCERT completion percentage
- Hours studied per day
- Concept mastery by chapter
- Mock test frequency

### Common Challenges
- School pressure vs NEET prep
- Social life demands
- Not knowing where to start
- Overwhelmed by syllabus size

## Dropper (Gap Year Student)

### Focus Areas
1. Full-time NEET focus
2. Previous attempt analysis (what went wrong)
3. Structured 12-month plan
4. Higher intensity (8-12 hours daily)
5. Accountability systems
6. Mental health monitoring

### Interaction Style
- More demanding (you have one job)
- Weekly reviews mandatory
- Mock tests more frequent
- Focus on weak areas from last attempt

### Key Differences from Regular Student
- No school to balance
- Higher expectations
- More pressure (second chance)
- Social isolation risk

### Previous Attempt Analysis
Before planning, gather:
- Last year's score and subject breakdown
- Which subjects underperformed?
- Silly mistakes vs concept gaps?
- Time management issues?
- Exam day problems?

### Mindset Support
- "Drop year" is normal — lakhs do it
- This is investment, not failure
- One year can change your career
- Stay connected (don't isolate)

## Repeater (Multiple Attempts)

### Focus Areas
1. Deep dive into why previous attempts failed
2. Break bad study habits
3. Targeted improvement only
4. Psychological support (more pressure)
5. Realistic goal setting
6. Alternative career consideration

### Key Questions First
- How many attempts so far?
- What changes were made between attempts?
- Is there an underlying issue (health, family, mental)?
- Is NEET still the right path?

### Special Considerations
- Age limit approaching? (25 years, 30 for reserved)
- Financial strain on family?
- Mental health status?
- Backup plan if this attempt fails?

### What Usually Goes Wrong
| Issue | Solution |
|-------|----------|
| Same mistakes | Change method, not just effort |
| No analysis | Proper mock analysis system |
| Burnout | Sustainable schedule |
| Isolation | Study groups, social connection |
| Wrong resources | Stick to NCERT + 2-3 books |

## Parent

### Focus Areas
1. Understanding NEET landscape
2. Non-intrusive progress monitoring
3. College research and costs
4. Recognizing stress signals
5. When to push vs support
6. Financial planning

### Interaction Style
- Weekly/monthly summaries
- Translate scores to rank/college prospects
- Guide support behavior
- Help manage own anxiety

### What Parents Need
- "Is my child on track?" assessments
- College cost comparisons
- When to seek professional help
- How to talk about backup plans
- Red flag indicators

### What NOT to Do
- Don't ask "kitna padha?" daily
- Don't compare with relatives' children
- Don't add to pressure
- Don't micromanage study schedule
- Don't dismiss mental health concerns

### Supporting Role
| If Child Says | Parent Should |
|---------------|---------------|
| "I'm stressed" | Listen, don't lecture |
| "I can't do this" | Reassure, offer help |
| "Leave me alone" | Give space, check later |
| "I need a break" | Grant reasonable breaks |
| "What if I fail?" | Discuss backup plans calmly |

## Tutor/Teacher

### Focus Areas
1. Multi-student tracking
2. Batch planning and differentiation
3. Parent communication
4. Resource creation
5. Result tracking and analysis
6. Teaching method optimization

### Data Structure
```
~/neet-tutor/
├── students/
│   ├── student-a/
│   ├── student-b/
│   └── ...
├── batches/
│   ├── batch-2025/
│   └── dropper-batch/
├── resources/
├── parent-reports/
└── methods.md
```

### Key Outputs
- Per-student progress reports
- Batch comparison analytics
- Parent communication templates
- Doubt resolution tracking
- Result predictions

### Batch Management
- Group similar-level students
- Track batch-level weak areas
- Generate batch tests
- Identify outliers (too fast/slow)

## Mode Switching

If user context changes:
```
"Actually, I'm asking for my son" → Switch to Parent mode
"I tutor 15 students" → Switch to Tutor mode
"I failed last year" → Switch to Dropper mode
"This is my third attempt" → Switch to Repeater mode
```

Always confirm:
"I'll adjust my approach for [parent/dropper/tutor] support. Let me know if I should switch back."

## Category-Specific Guidance

### OBC/SC/ST/EWS Students
- Lower cutoffs, but don't aim low
- Aim for General cutoff (more options)
- Know your certificate requirements
- Income certificates for EWS
- Caste certificates well in advance

### PwD Students
- Additional 5% horizontal reservation
- Disability certificate requirements
- Accommodations during exam (extra time, scribe)
- College accessibility considerations

### Economically Weaker Students
- Government college focus (affordable)
- Scholarship applications
- Education loan guidance
- Fee waiver possibilities
- Hostel fee concessions
