# Study Methods for NEET

## The NCERT-First Principle

**90% of NEET questions are directly from NCERT.** This is not an exaggeration.

### NCERT Mastery Levels
| Level | What It Means |
|-------|---------------|
| Read | Read the chapter once |
| Understood | Can explain concepts |
| Memorized | Recall key facts, diagrams |
| Applied | Solved NCERT exemplar problems |
| Mastered | Can answer any variation |

### NCERT Reading Strategy
1. **First read** — Understand concepts (mark doubts)
2. **Second read** — Highlight key lines (these become questions)
3. **Third read** — Make notes/flashcards from highlights
4. **Revision reads** — Only highlights and notes

### What "NCERT line by line" means
- Every example, every diagram, every footnote
- Exact wordings matter (especially Biology)
- Don't paraphrase — memorize exact NCERT language

## Spaced Repetition System

### Flashcard Categories
1. **Biology diagrams** — Labeled diagrams (heart, nephron, flower)
2. **Chemistry reactions** — Named reactions with mechanisms
3. **Physics formulas** — Grouped by chapter
4. **NCERT exact lines** — Important definitions, statements

### Review Schedule
| After Learning | Review On |
|----------------|-----------|
| Day 0 | Same day evening |
| Day 1 | Next day |
| Day 3 | Third day |
| Day 7 | One week |
| Day 14 | Two weeks |
| Day 30 | One month |

### Active Recall Method
- Don't just read flashcards
- Cover the answer, try to recall
- If wrong → mark for more frequent review
- If right 3 times → space out further

## Subject-Specific Strategies

### Physics
**Problem-solving intensive.** Reading won't help; practice will.

1. **Concept first** — Understand the theory (watch lecture if needed)
2. **Formula sheet** — Write all formulas for chapter
3. **Solved examples** — NCERT + HC Verma
4. **Practice problems** — Start easy, build up
5. **Previous year questions** — Chapter-wise PYQs

**Red flags:**
- "I understand but can't solve" → Not enough practice
- "I get stuck midway" → Formula/concept gap

### Chemistry
**Three different approaches for three sections:**

**Physical Chemistry:**
- Like Physics — problem-solving based
- Master formulas and their applications
- Practice numerical problems heavily

**Organic Chemistry:**
- Pattern recognition
- Learn mechanisms, not just reactions
- Practice reaction chains

**Inorganic Chemistry:**
- Memorization heavy
- Use mnemonics
- NCERT is complete for this

### Biology (Botany + Zoology)
**Pure memory + understanding.**

1. **NCERT is everything** — Don't skip a single line
2. **Diagrams** — Draw and label repeatedly
3. **Tables** — Comparisons (mitosis vs meiosis, etc.)
4. **Processes** — Step-by-step (Krebs cycle, etc.)
5. **Exact terminology** — Use NCERT words

**High-yield approach:**
- Read NCERT 5+ times before exam
- Make your own notes (consolidates memory)
- Diagram practice daily

## Mock Test Strategy

### Frequency
| Phase | Mock Frequency |
|-------|----------------|
| Initial (6+ months) | 1 per month |
| Middle (3-6 months) | 2 per month |
| Final (1-3 months) | Weekly |
| Last month | 2-3 per week |

### During Mock
1. **Simulate real conditions** — Full 3.5 hours, no breaks
2. **Start with strong subject** — Build confidence
3. **Time per question** — ~1 min avg, mark and move
4. **Accuracy over attempts** — Leave if unsure (-1 hurts)
5. **Section B strategy** — Identify easiest 10 quickly

### After Mock (same day)
1. **Score without checking answers** — Check marked questions
2. **Full analysis** — Which errors were silly vs concept
3. **Error log** — Record every mistake
4. **Revision list** — Topics to revisit

## Time Management

### Daily Schedule Template (serious aspirant)
```
06:00-06:30  Wake, freshen up
06:30-07:30  Yesterday's revision
07:30-12:30  Study Block 1 (Biology focus)
12:30-14:00  Lunch + rest
14:00-18:00  Study Block 2 (Physics + Chemistry)
18:00-19:00  Break/exercise
19:00-22:00  Study Block 3 (weak areas)
22:00-23:00  Light revision + flashcards
23:00        Sleep
```
**Total: 12-13 hours** (sustainable long-term)

### Subject Time Split
| Subject | Daily Hours | Rationale |
|---------|-------------|-----------|
| Biology | 4-5h | Maximum marks, memorization needs repetition |
| Chemistry | 3-4h | Balanced between memory and problems |
| Physics | 3-4h | Fewer marks but needs more practice per topic |

### Weekly Planning
- **6 days** — Regular subjects
- **1 day** — Mock test + revision of weak areas

## Resource Hierarchy

### Must-Use (Non-negotiable)
1. **NCERT** (Class 11 + 12) — All subjects
2. **NCERT Exemplar** — Additional problems
3. **Previous Year Questions** — Last 10 years

### Recommended Supplements
| Subject | Resource | Purpose |
|---------|----------|---------|
| Physics | HC Verma | Concept + Problems |
| Physics | DC Pandey | More practice |
| Chemistry | MS Chauhan (Organic) | Advanced problems |
| Chemistry | VK Jaiswal (Inorganic) | Comprehensive coverage |
| Biology | MTG Fingertips | Quick revision |
| Biology | Trueman's | Additional MCQs |

### Avoid
- Too many books (stick to 2-3 per subject)
- YouTube rabbit holes without structure
- Telegram/WhatsApp "study groups" (time sinks)
