---
name: near-multi-account
description: Secure multi-account management for NEAR Protocol with encrypted credential storage, account switching, and balance aggregation.
---

# NEAR Multi-Account Manager

A secure and comprehensive OpenClaw skill for managing multiple NEAR Protocol accounts. Store credentials, switch between accounts, check balances, transfer NEAR, and track transactions across all your accounts from one unified interface.

## What It Does

- 🔐 **Secure Credential Storage** - Encrypted storage for multiple NEAR account private keys using AES-256-CBC
- 🔄 **Account Switching** - Quickly set and switch between active accounts for seamless operations
- 💰 **Balance Management** - Check balances for individual accounts or all accounts at once
- 💸 **NEAR Transfers** - Transfer NEAR between accounts with a single command
- 📊 **Account Summaries** - Get comprehensive overviews of all managed accounts including total holdings
- 📜 **Transaction Tracking** - View account information and transaction history via NEAR explorer
- 📤 **Export/Import** - Backup and restore account information (private keys excluded for security)
- 🗑️ **Account Management** - Add, remove, and manage accounts with confirmation safeguards

## Use Cases

- **Developers** - Manage multiple testnet and mainnet accounts during development
- **Traders** - Track balances across multiple trading accounts
- **Organizations** - Manage team accounts with quick switching between them
- **DeFi Users** - Monitor and move funds between accounts for yield farming or staking
- **Power Users** - Centralized management of NEAR portfolio

## Requirements

- Node.js runtime (bundled with OpenClaw)
- Valid NEAR Protocol account(s)
- Private key(s) in format: `ed25519:...`

## Usage Examples

### Add a NEAR Account
```javascript
await add_account({
  accountId: "myaccount.near",
  privateKey: "ed25519:4K...",
  name: "Main Wallet"
});
```

### Check All Balances
```javascript
await get_all_balances();
```

### Transfer NEAR
```javascript
await transfer({
  to: "recipient.near",
  amount: "5.0"
});
```

### Get Account Summary
```javascript
await account_summary();
```

## Security Features

- **AES-256-CBC Encryption** - All private keys are encrypted at rest
- **Custom Encryption Keys** - Set via `NEAR_SKILL_KEY` environment variable
- **Confirmation Required** - Account removal requires explicit confirmation
- **No Key Export** - Export functions exclude private keys for security
- **Local Storage** - Data never leaves your machine unless explicitly exported

## Technical Details

- Uses NEAR SDK (near-api-js) for blockchain interactions
- Supports NEAR mainnet (testnet support available via configuration)
- Encrypted data stored in `~/.openclaw/skills/near-multi-account-manager/`
- Active account tracking via separate file for quick access

## License

MIT
