---
name: near-best-practices
description: Comprehensive NEAR best practices guide with 100+ terms covering wallet security, smart contracts, and DeFi safety.
---

# NEAR Best Practices Guide Skill

Comprehensive best practices for NEAR wallet, contracts, and DeFi.

## Description

This skill provides best practices guidance for NEAR development, covering wallet security, contract patterns, DeFi safety, and more. Includes 100+ terms and explanations accessible via CLI commands.

## Features

- Browse best practices by category
- Search for specific terms
- Get detailed explanations
- Quick reference guides
- Security guidelines

## Commands

### `near-best browse [category]`
Browse best practices by category.

**Categories:**
- wallet - Wallet security and management
- contracts - Smart contract best practices
- defi - DeFi safety guidelines
- keys - Private key management
- gas - Gas optimization
- testing - Testing and deployment

### `near-best search <term>`
Search for a specific term or keyword.

### `near-best get <term>`
Get detailed explanation for a specific term.

### `near-best list`
List all available terms.

### `near-best random`
Get a random best practice tip.

## Categories

### Wallet
- Account recovery
- Seed phrase storage
- Multi-sig wallets
- Hardware wallet integration

### Contracts
- NEP standards
- Access control patterns
- Upgrade strategies
- Testing methodologies

### DeFi
- Risk assessment
- Slippage protection
- Liquidity provision
- Yield farming safety

### Keys
- Key rotation
- Access keys
- Full access keys
- Function call keys

## References

- NEAR Documentation: https://docs.near.org/
- NEAR Standards (NEPs): https://github.com/near/NEPs
- NEAR Security: https://docs.near.org/develop/contracts/security
