# NEAR Best Practices Guide Skill

Access comprehensive NEAR best practices documentation.

## Installation

The skill is installed in `~/.openclaw/skills/near-best-practices/`

## Usage

### Browse by Category

```bash
node scripts/best.js browse wallet
node scripts/best.js browse contracts
node scripts/best.js browse defi
```

### Search for a Term

```bash
node scripts/best.js search "seed phrase"
node scripts/best.js search gas
```

### Get Detailed Explanation

```bash
node scripts/best.js get "seed phrase"
node scripts/best.js get nep-171
```

### List All Terms

```bash
node scripts/best.js list
```

### Random Tip

```bash
node scripts/best.js random
```

## Categories

- wallet - Wallet security and management
- contracts - Smart contract best practices
- defi - DeFi safety guidelines
- keys - Private key management
- gas - Gas optimization
- testing - Testing and deployment

## References

- NEAR Documentation: https://docs.near.org/
- NEP Standards: https://github.com/near/NEPs
