---
name: near-agent-skills
description: Comprehensive agentic skills for NEAR Protocol, including gas optimization and on-chain analytics.
version: 1.0.0
author: mastrophot
tags:
  - near
  - blockchain
  - analytics
  - gas-optimizer
  - agent-skills
---

# NEAR Agent Skills

A collection of specialized tools for interacting with the NEAR Protocol, optimized for autonomous agents.

## Features

### ⛽ Gas Optimizer

- **`near_gas_estimate`**: Real-time TGas estimation for contract calls.
- **`near_gas_optimize`**: Actionable tips to reduce contract execution costs.
- **`near_gas_history`**: Historical gas usage trends for accounts.
- **`near_gas_compare`**: Cost comparison between NEAR and Ethereum.

### 📊 On-Chain Analytics

- **`near_analytics_network`**: Network throughput and health metrics.
- **`near_analytics_whales`**: Tracking high-value transactions.
- **`near_analytics_trending`**: Identifying the most active smart contracts.
- **`near_analytics_defi`**: TVL and volume stats for the NEAR DeFi ecosystem.

## Setup

```bash
npm install
npm run build
```

## Usage

These skills are designed to be run via OpenClaw. Each command corresponds to a specific tool exported in the package.
