# IATA Airport Codes Reference

Quick reference for common airport codes used in flight searches.

## Major International Hubs

### United States
- **JFK** - New York John F. Kennedy International
- **EWR** - Newark Liberty International
- **LGA** - New York LaGuardia
- **LAX** - Los Angeles International
- **SFO** - San Francisco International
- **ORD** - Chicago O'Hare International
- **MIA** - Miami International
- **ATL** - Atlanta Hartsfield-Jackson
- **DFW** - Dallas/Fort Worth International
- **SEA** - Seattle-Tacoma International
- **BOS** - Boston Logan International
- **IAD** - Washington Dulles International
- **DCA** - Washington Reagan National

### United Kingdom & Ireland
- **LHR** - London Heathrow
- **LGW** - London Gatwick
- **STN** - London Stansted
- **LTN** - London Luton
- **MAN** - Manchester
- **EDI** - Edinburgh
- **DUB** - Dublin

### Continental Europe
- **CDG** - Paris Charles de Gaulle
- **ORY** - Paris Orly
- **FRA** - Frankfurt
- **MUC** - Munich
- **AMS** - Amsterdam Schiphol
- **BRU** - Brussels
- **MAD** - Madrid Barajas
- **BCN** - Barcelona El Prat
- **FCO** - Rome Fiumicino
- **MXP** - Milan Malpensa
- **LIN** - Milan Linate
- **VCE** - Venice Marco Polo
- **ZRH** - Zurich
- **GVA** - Geneva
- **VIE** - Vienna
- **PRG** - Prague
- **WAW** - Warsaw
- **CPH** - Copenhagen
- **ARN** - Stockholm Arlanda
- **OSL** - Oslo
- **HEL** - Helsinki
- **LIS** - Lisbon
- **ATH** - Athens

### Middle East
- **DXB** - Dubai International
- **DWC** - Dubai World Central (Al Maktoum)
- **AUH** - Abu Dhabi International
- **DOH** - Doha Hamad International
- **IST** - Istanbul Airport
- **SAW** - Istanbul Sabiha Gökçen
- **TLV** - Tel Aviv Ben Gurion

### Asia-Pacific
- **HKG** - Hong Kong International
- **SIN** - Singapore Changi
- **NRT** - Tokyo Narita
- **HND** - Tokyo Haneda
- **ICN** - Seoul Incheon
- **PEK** - Beijing Capital
- **PKX** - Beijing Daxing
- **PVG** - Shanghai Pudong
- **SHA** - Shanghai Hongqiao
- **CAN** - Guangzhou Baiyun
- **SZX** - Shenzhen Bao'an
- **BKK** - Bangkok Suvarnabhumi
- **SYD** - Sydney Kingsford Smith
- **MEL** - Melbourne
- **AKL** - Auckland

### Canada
- **YYZ** - Toronto Pearson
- **YVR** - Vancouver International
- **YUL** - Montreal Trudeau
- **YYC** - Calgary International

### Latin America
- **MEX** - Mexico City International
- **GRU** - São Paulo Guarulhos
- **GIG** - Rio de Janeiro Galeão
- **EZE** - Buenos Aires Ezeiza
- **SCL** - Santiago International
- **BOG** - Bogotá El Dorado
- **LIM** - Lima Jorge Chávez

### Africa
- **CAI** - Cairo International
- **JNB** - Johannesburg OR Tambo
- **CPT** - Cape Town International
- **NBO** - Nairobi Jomo Kenyatta
- **ADD** - Addis Ababa Bole

## Regional European Airports

### Germany
- **TXL/BER** - Berlin Brandenburg
- **HAM** - Hamburg
- **DUS** - Düsseldorf
- **STR** - Stuttgart
- **CGN** - Cologne Bonn

### France
- **NCE** - Nice Côte d'Azur
- **LYS** - Lyon Saint-Exupéry
- **MRS** - Marseille Provence
- **TLS** - Toulouse Blagnac

### Spain & Portugal
- **AGP** - Málaga
- **SVQ** - Seville
- **PMI** - Palma de Mallorca
- **OPO** - Porto

### Italy
- **NAP** - Naples
- **BLQ** - Bologna
- **PSA** - Pisa
- **FLR** - Florence
- **BRI** - Bari
- **CTA** - Catania

### Scandinavia
- **BGO** - Bergen
- **TRD** - Trondheim
- **GOT** - Gothenburg
- **AAL** - Aalborg

### Eastern Europe
- **BUD** - Budapest
- **OTP** - Bucharest
- **SOF** - Sofia
- **ZAG** - Zagreb
- **BEG** - Belgrade

### Benelux
- **LUX** - Luxembourg
- **EIN** - Eindhoven
- **RTM** - Rotterdam

### Switzerland & Austria
- **BSL** - Basel/Mulhouse
- **BRN** - Bern
- **LUG** - Lugano
- **INN** - Innsbruck
- **SZG** - Salzburg

## Low-Cost Carrier Hubs

Many budget airlines operate primarily from these airports:

- **STN** (London Stansted) - Ryanair hub
- **LTN** (London Luton) - easyJet, Wizz Air
- **BVA** (Paris Beauvais) - Ryanair
- **CIA** (Rome Ciampino) - Ryanair, Wizz Air
- **BGY** (Milan Bergamo) - Ryanair
- **HHN** (Frankfurt Hahn) - Ryanair
- **NRN** (Düsseldorf Weeze) - Ryanair
- **BRE** (Bremen) - Ryanair
- **NYO** (Stockholm Skavsta) - Ryanair
- **TRF** (Oslo Torp) - Ryanair, Wizz Air

## How to Look Up Unknown Codes

If you encounter an airport code not in this list:

1. **Ask the user**: "I don't recognize code XXX. What city/airport is this?"
2. **Context clues**: Look at city names mentioned in conversation
3. **Regional patterns**:
   - US codes: 3 random letters (JFK, LAX, ORD)
   - Canada codes: Y + 2 letters (YYZ, YVR, YUL)
   - Australia codes: Often city names (SYD, MEL, BNE)
4. **Major cities**: Default to main airport (London→LHR, Paris→CDG, Tokyo→NRT)

## Common Ambiguities

### Multiple airports in same city

**London (6 airports)**:
- LHR (Heathrow) - Major international hub
- LGW (Gatwick) - Second largest, south of London
- STN (Stansted) - Budget airlines, northeast
- LTN (Luton) - Budget airlines, north
- LCY (City) - Business flights, city center
- SEN (Southend) - Small regional

**New York (3 major)**:
- JFK (Kennedy) - International hub
- EWR (Newark) - In New Jersey, international
- LGA (LaGuardia) - Domestic flights

**Paris (2 major)**:
- CDG (Charles de Gaulle) - Main international hub
- ORY (Orly) - Secondary international, domestic

**Milan (2 major)**:
- MXP (Malpensa) - International long-haul
- LIN (Linate) - Domestic and European

**Tokyo (2 major)**:
- NRT (Narita) - International, 60km from city
- HND (Haneda) - Domestic and some international, closer to city

**Istanbul (2)**:
- IST (Istanbul Airport) - New main hub
- SAW (Sabiha Gökçen) - Asian side, budget airlines

**Dubai (2)**:
- DXB (Dubai International) - Main hub
- DWC (World Central) - Al Maktoum, secondary

### Always Clarify

When a user mentions a city with multiple airports, ask:
- "London has several airports. Do you mean Heathrow (LHR) or Gatwick (LGW)?"
- "For New York, are you flying into JFK, Newark (EWR), or LaGuardia (LGA)?"

This ensures accurate searches and prevents booking mistakes.

---

**Note**: This list covers ~200 of the most commonly used airports. For complete coverage, the Navifare system has access to 10,000+ airports worldwide.
