# Naver Search Skill 명세서

이 문서는 OpenClaw 에이전트가 네이버 검색 스킬을 가장 효율적으로 호출하고 결과를 분석할 수 있도록 돕는 지침서입니다.

## 🎯 스킬 목적
네이버의 실시간 뉴스, 쇼핑 데이터, 영상 및 장소 정보를 정교한 파라미터 제어를 통해 확보합니다.

## 🛠️ 호출 명세 (Command Reference)

### 1. 통합 어그리게이터 (추천)
에이전트가 여러 카테고리의 정보를 한꺼번에 파악해야 할 때 사용합니다.
```bash
python3 scripts/naver_search.py "<검색어>"
```
- **반환 데이터**: 최신 뉴스(3건), 쇼핑 트렌드(3건), 이미지 썸네일, 비디오 요약, 상위 웹 결과.

### 2. 고성능 뉴스 엔진
```bash
python3 scripts/naver_news.py "<검색어>" --sort <sort> --time <time>
```
- `--sort`: `0`(관련도순), `1`(최신순-추천), `2`(오래된순)
- `--time`: `all`, `1h`(1시간), `1d`(1일), `1w`(1주), `1m`(1개월)
- **팁**: 실시간 이슈 분석 시 `--sort 1 --time 1d` 조합이 가장 유용합니다.

### 3. 쇼핑/이미지/비디오 전문 엔진
| 기능 | 스크립트 | 특수 옵션 |
| :--- | :--- | :--- |
| **쇼핑** | `naver_shopping.py` | 가격, 판매처 정보 포함 |
| **이미지** | `naver_images.py` | `--num [n]` (결과 개수 제어) |
| **비디오** | `naver_video.py` | 출처 및 재생 시간 정보 포함 |

### 4. 예약 및 장소 엔진
장소의 물리적 위치나 예약 링크가 필요할 때 호출합니다.
```bash
python3 scripts/naver_booking.py "<맛집/장소명>"
```
- **반환 데이터**: 업체명, 주소, 카테고리, 네이버 예약 상품 정보 및 링크.

## 📊 출력 포맷 제어
모든 명령어 뒤에 `--format` 옵션을 추가하여 데이터 구조를 선택할 수 있습니다.
- `compact` (기본): 에이전트가 읽기 좋은 핵심 요약 텍스트.
- `json`: 코드 레벨에서 정밀 분석이 필요한 경우 유용한 JSON raw 데이터.

## 🔐 보안 및 환경 변수
- 본 스킬은 **`SERPAPI_API_KEY`** 환경 변수가 필수입니다. 
- 환경 변수가 설정되어 있지 않다면 스킬 루트 폴더의 `.env` 파일에 키를 기입하세요.

---
**유의사항**: 네이버 엔진 특성상 검색어 뒤에 '뉴스', '예약' 등의 단어를 직접 포함하면 더 정확한 결과를 얻을 수 있습니다. (`naver_news.py`, `naver_booking.py` 내부에 이미 일부 자동 보강 로직이 포함되어 있습니다.)
