"""
Natural Language Planner - Python utilities for task and project management.

This package provides core functionality for the Natural Language Planner skill,
including file operations, configuration management, search indexing, and a
local dashboard server.

Modules:
    utils           - Shared utilities (slug generation, YAML/Markdown parsing, etc.)
    config_manager  - User settings and configuration management
    file_manager    - Core CRUD operations for projects and tasks
    index_manager   - Fast search and lookup optimization
    dashboard_server - Local web server for the visual dashboard
    tunnel          - Cloudflare/ngrok tunnel integration for remote access
    export          - Static HTML snapshot export for deployment
"""

__version__ = "1.0.0"
