# Native UI with Expo Router

Patterns and conventions for building native mobile applications with Expo Router and React Native, following Apple Human Interface Guidelines.

## What's Inside

- Route conventions, dynamic routes, groups, and folder organization
- Native tab bar with NativeTabs and iOS 26 features
- SF Symbols with expo-symbols
- Native iOS controls: Switch, Slider, SegmentedControl, DateTimePicker
- Blur effects and liquid glass visual effects
- Reanimated animations, gestures, and scroll-driven effects
- Search bar integration and filtering patterns
- CSS gradients, camera, audio, video, storage
- Link previews, context menus, modals, and form sheets
- Stack headers and toolbar customization

## When to Use

- Building native mobile apps with Expo Router
- Implementing iOS-style navigation and UI controls
- Adding native animations and visual effects
- Setting up route structure for mobile apps
- Following Apple Human Interface Guidelines in React Native

## Installation

```bash
npx add https://github.com/wpank/ai/tree/main/skills/frontend/native-ui
```

### OpenClaw / Moltbot / Clawbot

```bash
npx clawhub@latest install native-ui
```

### Manual Installation

#### Cursor (per-project)

From your project root:

```bash
mkdir -p .cursor/skills
cp -r ~/.ai-skills/skills/frontend/native-ui .cursor/skills/native-ui
```

#### Cursor (global)

```bash
mkdir -p ~/.cursor/skills
cp -r ~/.ai-skills/skills/frontend/native-ui ~/.cursor/skills/native-ui
```

#### Claude Code (per-project)

From your project root:

```bash
mkdir -p .claude/skills
cp -r ~/.ai-skills/skills/frontend/native-ui .claude/skills/native-ui
```

#### Claude Code (global)

```bash
mkdir -p ~/.claude/skills
cp -r ~/.ai-skills/skills/frontend/native-ui ~/.claude/skills/native-ui
```

## Related Skills

- `expo-native-ui` — Similar patterns with slightly different organization

---

Part of the [Frontend](..) skill category.
