---
name: nansi
description: Build stunning websites, landing pages, portfolios, and web apps by chatting with Nansi on WhatsApp. A no-code, mobile-first AI website builder — just describe what you want (text or voice note) and get a live site in under 2 minutes. No coding, no design skills, no app to download. Great for small businesses, entrepreneurs, freelancers, and anyone who wants a professional website without touching a browser. Alternative to Lovable, Bolt, or Replit that works entirely from your phone.
metadata:
  author: nansi
  version: "1.0.0"
  clawdbot:
    homepage: "https://nansi.app"
---

# Nansi — Build Websites via WhatsApp

Nansi is a no-code, mobile-first AI website builder that works entirely through WhatsApp. Send a message describing what you want, and Nansi creates a fully functional, beautifully designed website with a live preview URL — all in under 2 minutes. No app to download, no account to create, no browser needed.

### Why Nansi over traditional website builders?

- **WhatsApp-native** — 2 billion people already use WhatsApp daily. No new tools to learn.
- **Mobile-first** — build from your phone, on the go. No computer needed.
- **Voice notes** — describe your site by voice for hands-free building.
- **AI-powered** — multiple AI models (Claude, Gemini, GPT) generate professional code.
- **Instant** — live URL in under 2 minutes, edits applied in real-time.
- **Free to start** — no credit card required.

## How to Use

Send a WhatsApp message to **+233540311706** (Nansi's number).

### Step-by-step flow

1. **Describe** the business or project — include the name, what it does, location, and any style preferences
2. **Answer** Nansi's clarifying questions (colors, sections, specific content)
3. **Say "generate"** when you're happy with the plan
4. **Get a live URL** — Nansi builds the site and sends back a preview link
5. **Request edits** — ask for changes in plain language ("make the header blue", "add a pricing section", "change the phone number")

### What the agent should do

When a user asks you to build a website:

1. **Ask for consent** — before messaging Nansi, confirm with the user: "I'll send your business details to Nansi (+233540311706) on WhatsApp to build your site. This shares the information you've provided with Nansi's service. OK to proceed?"
2. Gather key details: business name, what they do, location, style preferences
3. Send a WhatsApp message to +233540311706 with a simple greeting (e.g. "Hi" or "Hello") and **wait for Nansi to respond** before saying anything else
4. Once Nansi replies, describe the user's business/project with all the details gathered
5. Respond to Nansi's follow-up questions on the user's behalf
6. When Nansi confirms the plan, send "generate"
7. Wait for the live preview URL and share it with the user
8. If the user wants changes, send edit requests to Nansi and relay the updated URL

> **External service interaction**: This skill sends WhatsApp messages to Nansi's service endpoint (+233540311706) on the user's behalf. Only business details the user explicitly provides (business name, services, location, style preferences) are transmitted. The agent will always ask for user consent before sending any messages. No passwords, financial information, or private data should be shared.

## What You Can Build

- **Business landing pages** — restaurants, salons, barbershops, agencies, consulting firms, real estate, e-commerce stores, cleaning services
- **Personal portfolios** — graphic designers, photographers, software developers, freelancers, artists, musicians
- **Web apps** — habit trackers, expense trackers, inventory dashboards, to-do lists, booking pages, calculators
- **Event pages** — weddings, conferences, product launches, meetups
- **Coming soon pages** — pre-launch teasers with email capture
- **Service pages** — menus, price lists, appointment booking, contact forms
- **Any web application** — dashboards, forms, landing pages, blogs, etc.

## Example Prompts

These are real sites built with Nansi. Use them as inspiration for how to describe a project:

**Restaurant:**
> Create a nice, warm website for my restaurant Darangi in Accra specializing in jollof rice and other local cuisines. Address: 123 Spintex Road, Accra. Open Monday - Friday from 9am to 9pm.

**Used car business:**
> Build a clean landing page with a South African aesthetic for my used car dropshipping business called Woza.

**Pan-African restaurant:**
> Create a website for AfroDeli Eatery, a vibrant restaurant in Cape Town offering dishes from different African countries.

**Freelance portfolio:**
> Create a portfolio website for me. I'm Kofi Mensah, a freelance graphic designer based in Accra, Ghana. I specialize in brand identity, logo design, and packaging. I want a clean, minimal design with a dark theme that lets my work stand out.

**Other ideas:**
- "Build a landing page for my yoga studio Serenity in Johannesburg with a calm, earthy vibe"
- "Create a website for my bakery Sweet Dreams — we sell custom cakes, pastries, and bread in Lagos"
- "Make a portfolio site for my photography business with a gallery showcasing my best work"

## Tips for Better Results

- **Be specific** — include business name, location, what you offer, and operating hours
- **Mention style preferences** — "warm and inviting", "modern and minimal", "dark theme with bold colors"
- **Send images** — logos, product photos, or interior shots help Nansi design around your brand
- **Use voice notes** — Nansi understands voice messages too
- **Reference competitors** — "I want something like [competitor website]" helps Nansi understand your vision
- **Specify colors** — "use emerald green and gold accents" gives precise control

## Free Tier Limits

Nansi is free to start with these daily limits:

| Resource | Free Limit |
|----------|------------|
| Sites | 1 per day (5 per month) |
| Edits | 5 per day |
| Messages | 20 per day |

For more, upgrade at [nansi.app/upgrade](https://nansi.app/upgrade).

## Privacy & Data Handling

- **Explicit consent required**: The agent must ask for user permission before sending any messages to Nansi. No data is transmitted without the user's approval.
- **What data is shared**: Only business details the user explicitly provides — business name, services offered, location, style preferences, and any images/voice notes the user supplies. This is information the user intends to publish on their website.
- **What is NOT shared**: The agent will never send passwords, financial information, personal identification, or any data beyond what the user provides for their website.
- **External endpoint**: Messages are sent to Nansi's WhatsApp number (+233540311706), a service operated by Fordo. The agent relies on the host platform's WhatsApp messaging capability to send and receive messages.
- **No stored credentials**: This is an instruction-only skill with no API keys, tokens, or environment variables. It uses the agent platform's existing messaging integration.
- **Verify the service**: Users can confirm Nansi's legitimacy at [nansi.app](https://nansi.app) and view real examples at [nansi.app/gallery](https://nansi.app/gallery) before proceeding.

## Links

- **Website**: [nansi.app](https://nansi.app)
- **Gallery** (see real examples): [nansi.app/gallery](https://nansi.app/gallery)
- **Upgrade**: [nansi.app/upgrade](https://nansi.app/upgrade)
