---
name: naming-and-domains
description: Name a business, product, or service and secure a matching domain. Use when brainstorming names, evaluating name quality, checking domain availability, choosing between name candidates, or planning a domain strategy. Covers naming frameworks, name-quality criteria, trademark basics, domain extensions, and the full name-to-domain pipeline. Trigger on "help me name my business", "name ideas", "find a domain", "business name", "product name", "domain name", "what should I call it", "naming strategy", "check domain availability".
---

# Naming and Domains

## Overview
Your name is the first brand touchpoint and the one customers repeat most. A bad name creates friction at every stage — hard to spell, hard to find, easy to confuse with competitors. A great name is memorable, pronounceable, and available. This playbook takes you from zero to a locked-in name with a matching domain.

---

## Phase 1: Define Naming Constraints

Before generating names, set the guardrails. This prevents wasting time on names that can't work.

**Must-haves:**
- [ ] Pronounceable by a stranger on first read (no silent letters, no ambiguous spellings)
- [ ] Spellable after hearing it once (no "Is it a K or a C?" moments)
- [ ] Memorable after hearing it once
- [ ] Available as a .com domain (or your chosen primary extension)
- [ ] Not trademarked by a significant competitor in your space
- [ ] Works in all the languages your customers speak (if international)

**Preferences (nice-to-have, not dealbreakers):**
- Evokes the core benefit or feeling of the product
- Short (ideally ≤ 2 syllables, max 3)
- Works as a standalone word or has intuitive meaning
- No hyphens in the domain
- No numbers in the domain

---

## Phase 2: Generate Name Candidates (Aim for 30+)

Use multiple naming techniques. Quantity now, quality later.

### Technique 1: Benefit-Based Names
Name the outcome, not the feature. What does the customer get?

- Brainstorm 10 words/phrases related to the core benefit (e.g., for a time-tracking tool: speed, clarity, focus, ease, flow, simplicity, clarity)
- Combine, modify, abbreviate, or stylize these words

### Technique 2: Metaphor/Analogy Names
Map a concept from another domain onto what your product does.

- What does your product remind you of from nature, sports, architecture, mythology, everyday objects?
- Example: A project management tool → "Scaffold" (building metaphor), "Compass" (navigation metaphor)
- List 10 metaphors, then derive name candidates from each

### Technique 3: Made-Up / Portmanteau Names
Combine syllables from real words to create something new and unique.

- Take 2-3 relevant words and mash syllables together
- Example: "Client" + "Pulse" → "Clipulse" or just "Clipul"
- These are often the most available as domains

### Technique 4: Descriptive / Literal Names
Simply describe what the product does, clearly.

- "InvoiceBot", "ReportFlow", "ClientPing"
- Less creative but highly searchable and instantly understood
- Best when the market is confusing and clarity wins

### Technique 5: Abstract / Evocative Names
Short, punchy words that feel right but don't literally describe the product.

- Think: Notion, Figma, Stripe, Slack
- Pick 10 short (1-2 syllable) words that evoke the feeling of your brand: speed, calm, power, clarity, trust
- These require more brand-building work but are highly memorable

---

## Phase 3: Filter and Score Candidates

Take your 30+ candidates and run them through this scoring rubric (1-3 per criterion):

| Criterion | 1 | 2 | 3 |
|---|---|---|---|
| **Pronounceability** | Ambiguous pronunciation | Mostly clear | Obviously clear on first read |
| **Memorability** | Forgettable | Decent | Sticks after one hearing |
| **Spelling clarity** | Could be spelled multiple ways | Slight ambiguity | Only one obvious spelling |
| **Relevance** | No connection to the product | Loose connection | Strong, intuitive connection |
| **Availability** | .com taken by a major player | .com taken but alternative available | .com available |
| **Trademark risk** | Likely conflicts exist | Possible conflicts | Clean — no obvious conflicts |

**Score each candidate.** Top 5-8 advance to domain and trademark checks.

---

## Phase 4: Domain and Trademark Checks

### Domain Availability
Check .com first. .com is still the strongest signal of legitimacy for most audiences.

**Check tools:**
- Namecheap, Google Domains, or any registrar's search bar
- Lean Domains (suggests available domains with your keyword)
- NameMesh (generates creative available combinations)

**If .com is taken, evaluate alternatives in this priority order:**
1. **.io** — Strong in tech/SaaS. Widely accepted and understood.
2. **.co** — Clean, professional, short. Often available when .com isn't.
3. **.app** — Google-backed, good for apps. Implies software.
4. **.dev** — Good for developer-facing products.
5. **Avoid:** .biz, .info, .xyz — these erode credibility with most audiences.

**Decision rule:** If your .com is taken by an active, well-known competitor, do not fight it. Pick a different name where .com is clean. One confusable domain is a marketing nightmare forever.

### Trademark Check (Basic)
You are not a lawyer — but do a basic sanity check before committing:

- Search the USPTO trademark database (for US) or EUIPO (for EU) for your name.
- Google "[your name] trademark" and see what comes up.
- Check if any company in your industry or adjacent industries uses this name publicly.

**Red flags:** An active trademark in your exact industry or a company with significant presence using the same name. If you see either, pick a different name.

**Note:** A full trademark search by a lawyer costs $300-500 and is worth it before you invest heavily in the brand. Do the basic check now, the full check before you spend on branding.

---

## Phase 5: Final Selection and Validation

From your top 3-5 candidates (that passed domain + trademark checks), do a final validation round:

**1. Say it out loud 20 times.** Does it feel natural? Does it roll off the tongue?

**2. Have 5 strangers spell it after you say it.** (Text a friend, ask them to write it down after you say the name once.) If more than 1 person gets it wrong, the spelling is ambiguous.

**3. Google it.** What comes up? If the first page is dominated by something completely unrelated and popular, your name will fight for attention in search. Not ideal.

**4. Check social handles.** Search Twitter/X, Instagram, LinkedIn, YouTube for your name. Are the handles available? Consistency across platforms matters.

**5. Gut check with your target customer.** Share your top 3 names with 3-5 people in your target segment. Which one resonates? Which one feels trustworthy for the problem you solve? Their instincts matter more than yours here.

---

## Phase 6: Lock It In

Once you've chosen:
1. **Register the domain immediately.** Do not wait. Domains get snatched.
2. **Grab social handles** on Twitter/X, LinkedIn, Instagram, YouTube — even if you don't plan to use them all now. Consistency later requires availability now.
3. **Register a basic trademark** if you have budget and the name is important to your strategy (USPTO provisional application is ~$250).
4. **Document the name** in your brand guidelines with spelling, pronunciation, and any usage rules (e.g., capitalization style, whether "the" is part of the name).

---

## Naming Anti-Patterns
- Naming after yourself (unless you ARE the brand, e.g. a consultant). "Jatin's Tool" doesn't scale or sell.
- Choosing a name you love but your customers won't understand. Name for them, not for you.
- Settling for a .biz domain because the .com was taken. Find a better name instead.
- Ignoring international pronunciation. If you have any chance of customers outside your language, test the name with native speakers of other languages. Some names are accidentally offensive or meaningless in other languages.
- Overthinking it. A good name is good enough. Execution and product matter far more than the perfect name.
