# n8n_dispatch Agent Skill

This skill bridges OpenClaw with your existing n8n‑dispatch service via mcporter.  It exposes a single command `dispatch` that forwards the user’s request type and prompt to the registered MCP service.

## How it works

1. The command `dispatch` takes two required arguments:
   * `requestType` – one of `state`, `action`, or `historical`.
   * `text` – the raw user prompt.
2. The skill builds a JSON payload containing those two values and calls the MCP service `n8n_dispatch`.
3. The n8n workflow receives the payload, processes the request, and returns a response that OpenClaw prints.

## Usage

```bash
# In your OpenClaw session or a shell
n8n_dispatch dispatch state "What is the living room light status?"
```

The command will output something like: `Requested type: state and text: What is the living room light status?`

## Examples

| Request type | Prompt | Example command | What the service returns |
|--------------|--------|------------------|--------------------------|
| `state` | *“Is the garage door open?”* | `n8n_dispatch dispatch state "Is the garage door open?"` | *“Garage door is closed”* |
| `action` | *“Turn on the hallway light.”* | `n8n_dispatch dispatch action "Turn on the hallway light."` | *“Hallway light turned on”* |
| `historical` | *“Show me the temperature for yesterday.”* | `n8n_dispatch dispatch historical "Show me the temperature for yesterday."` | *Yesterday’s temperature: 72°F* |

## Configuration

Place this skill in your workspace under `skills/n8n_dispatch` and ensure your MCP service is registered:

```bash
openclaw mcporter add \
  --name "n8n_dispatch" \
  --url "http://your-n8n-host:8080/api"
```

Once the skill is loaded (`openclaw skills load n8n_dispatch`), you can start calling `dispatch` from any OpenClaw session.
