---
name: myfood-by
description: 食品库存管理与饮食推荐工具 — 支持食品库存（含有效期）登记/查询，推荐饮食前实时问询禁忌与健康需求（不保存），优先适配已有食材，标注库存食材并提醒临期商品，食谱生成依托主模型。
metadata: {"openclaw": {"emoji": "🥗"}}
---

# 🥗食品库存管理与饮食推荐工具

## 核心定位

一款专注于食品库存管理与个性化饮食推荐的工具，不存储任何个人健康敏感信息，通过实时问询获取饮食适配需求，助力用户高效利用现有食材、科学规划饮食。

## 一、核心功能与操作逻辑

### 1. 食品库存登记与查询

#### 支持场景

* 登记：用户可添加已购买食品信息，包括食品名称、有效期（非必填），系统自动同步至[技能目录下的references/my-food.md]文件（无该文件则自动生成）。

* 查询：用户可查询已登记的食品库存、有效期等信息。

* 更新：用户标记食品已吃完时，系统直接从[技能目录下的references/my-food.md]中删除该食品记录，确保库存信息准确。

#### 响应规则

* 登记 / 更新后，即时告知用户 “已成功登记 / 更新食品信息”“已移除已吃完食品记录” 等操作结果。

* 查询时，基于[技能目录下的references/my-food.md]中的记录，根据用户需求给出对应回答，清晰反馈现有食品清单、有效期情况。

### 2. 个性化饮食推荐

#### 推荐逻辑

1. 优先查询[技能目录下的references/my-food.md]中的现有食品，筛选符合用户实时告知的饮食需求的食材，优先推荐以现有食品为原料的食谱。

2. 若现有食品数量不足、种类单一或无适配食材，将依托主模型能力，基于用户实时反馈的饮食需求，直接生成个性化饮食方案。

3. 推荐结果呈现要求：

* 明确标注推荐食谱中已包含的用户现有食品（用【已有】标识）。

* 单独列出临期食品提醒（格式：“⚠️ 临期提醒：XXX（有效期至 XX）、XXX（有效期至 XX）”），与饮食推荐内容区分。

## 二、补充说明

1. 数据存储：仅保存食品库存相关信息（至[技能目录下的references/my-food.md]），不存储任何个人健康信息、饮食禁忌等敏感内容，所有饮食适配相关需求均通过实时问询获取。

2. 功能限制：无健康记录登记与查询功能，仅聚焦食品管理与饮食推荐。

3. 模型依赖：食谱分析、生成等需运算的场景，均依托主模型完成。