
---
# 固定元数据头（必须，AI 优先读取）
name: weather-query
description: 查询全球主要城市实时天气，支持中文查询（含温度、天气状况、湿度、风力）
version: 1.0.0
author: 你的名字
permissions: 网络访问权限（用于调用天气 API）
---

# Weather Query Skill（技能名称，可自定义）

## 1. Description（技能详细说明）
当用户询问天气相关问题时，使用此技能查询实时天气数据，以清晰、友好的中文格式返回结果，帮助用户快速了解目标城市的天气情况。

## 2. When to use（触发场景：明确 AI 何时调用此技能）
- 用户说：“北京今天天气怎么样？”
- 用户说：“上海明天会下雨吗？”
- 用户说：“纽约当前温度是多少？”
- 用户说：“成都后天的天气预报”
- 用户说：“帮我查一下广州近 3 天的天气”

## 3. How to use（调用逻辑：教 AI 如何使用技能）
1. 从用户消息中提取 2 个核心信息：
   - 目标城市（必须，如“北京”“上海”）；
   - 查询时间（可选，默认“今天”，支持“明天”“后天”）；
2. 调用内置天气查询工具（或外部公开天气 API）获取数据；
3. 整理数据并返回，格式要求：
   - 开头明确“城市 + 时间”（如“北京 2026年2月10日 天气”）；
   - 核心信息：温度（默认摄氏度）、天气状况（晴/雨/多云等）、湿度、风力；
   - 结尾补充温馨提示（如“今日有雨，建议带伞”）；
4. 若未提取到城市，主动追问用户确认具体城市。

## 4. Edge cases（边缘场景：处理异常情况）
- 模糊地点（如“家附近”“公司旁边”）：回复“请告诉我具体城市名称，以便准确查询天气”；
- 未支持城市（如小众县城）：回复“暂不支持该城市的天气查询，建议尝试省会或主要城市”；
- 未来多天查询（如“深圳近一周天气”）：优先返回未来 3 天概览，说明“长期预报精度有限，仅作参考”；
- 无网络情况：回复“当前网络不可用，无法查询天气，请检查网络连接后重试”。
