---
name: my-mind-manager
description: |
  my-mind 灵感文章创作管理技能。用于管理灵感、文章和创作素材。
  触发语包括：帮我管理my-mind、创建灵感、整理文章、发布文章、创作素材管理、初始化目录结构、my-mind
  可识别关键词：my-mind、灵感管理、文章创作、素材管理、笔记管理、目录初始化
---

# my-mind Manager Skill

帮助管理灵感、文章和创作素材的 AI 技能。

## 功能概述

### 1. 初始化目录结构

自动创建标准的 my-mind 目录结构：

```
my-mind/
├── ideas/              # 灵感库
│   ├── fleeting/       # 瞬时灵感
│   ├── structured/     # 整理后的灵感
│   └── projects/       # 项目构想
├── articles/           # 文章库
│   ├── drafts/         # 草稿
│   ├── published/     # 已发布
│   └── ideas/         # 文章构想
├── assets/             # 创作素材
│   ├── images/
│   ├── audios/
│   ├── videos/
│   └── attachments/
├── inbox/              # 收集箱
│   ├── temp/
│   └── to-process/
└── archive/           # 归档
```

### 2. 灵感管理

- **记录灵感**：快速记录碎片想法
- **整理灵感**：将瞬时灵感整理成结构化内容
- **归档灵感**：将完成的项目构想归档

### 3. 文章创作

- **创建草稿**：基于灵感创建新文章
- **编辑文章**：帮助续写、修改文章
- **发布文章**：标记为已完成/已发布

### 4. 素材管理

- 整理和归类素材
- 移动素材到正确位置
- 清理临时文件

---

## 使用流程

### 方式一：初始化新仓库

当用户说"初始化 my-mind"或"创建目录结构"时：

1. 创建目录结构
2. 生成 README.md 使用指南
3. 提交代码

### 方式二：记录灵感

当用户说"记录灵感"、"有个想法"时：

1. 询问灵感内容
2. 按日期创建文件到 `ideas/fleeting/`
3. 询问是否需要整理

### 方式三：写作文章

当用户说"写文章"、"创作"时：

1. 询问文章主题和方向
2. 创建草稿到 `articles/drafts/`
3. 逐步完善内容

### 方式四：发布文章

当用户说"发布文章"、"完成文章"时：

1. 确认文章已完成
2. 移动到 `articles/published/`
3. 按日期重命名

---

## 命名规范

### 灵感

- 瞬时灵感：`YYYY-MM-DD-简短描述.md`
- 整理后：`YYYY-MM-DD-主题.md`
- 项目：`项目名-阶段.md`

### 文章

- 草稿：`文章名-draft.md`
- 定稿：`YYYY-MM-DD-文章名.md`

---

## 重要规则

1. 所有文件使用 Markdown 格式
2. 灵感文件优先放入 `fleeting/`，再根据需要整理到 `structured/`
3. 文章发布前确认用户意图
4. 素材移动前确认目标路径
5. 定期提醒用户清理 `inbox/to-process/`

---

## 配套工具

- Obsidian
- Notion
- 任意 Markdown 编辑器
