export default async function run(input) {
  const question = input?.question?.trim() || "";

  // 1. Acknowledge
  const acknowledgment = question
    ? "I see what you're pointing at."
    : "There is no clear input yet.";

  // 2. Assess clarity
  const unclear =
    !question ||
    question.length < 12 ||
    question.includes("confused") ||
    question.includes("stuck") ||
    question.includes("should I");

  // 3. Choose response mode
  let response;
  let next_step;

  if (!question) {
    response =
      "Nothing can be addressed until a concrete situation is described.";
    next_step = "Describe the situation, not the emotion.";
  } else if (unclear) {
    response =
      "This is a signal of uncertainty, not a decision point yet.";
    next_step =
      "State what is happening, what you want, and what feels blocked.";
  } else {
    response =
      "Here is a grounded response, without assuming urgency or certainty: " +
      question;
    next_step =
      "Check whether this response reduces confusion. If not, refine the question.";
  }

  // 4. Return aligned output
  return {
    acknowledgment,
    response,
    next_step
  };
}
