import { exec } from "child_process";

function log(msg) {
  const time = new Date().toISOString();
  console.log(`[${time}] ${msg}`);
}

function checkMoltbook() {
  log("Heartbeat started.");

  exec("npx molthub@latest whoami", (error, stdout, stderr) => {
    if (error) {
      log("Heartbeat error: Molthub not reachable or not authenticated.");
      return;
    }

    if (stdout && stdout.trim()) {
      log(`Authenticated (stdout): ${stdout.trim()}`);
    }

    if (stderr && stderr.trim()) {
      log(`Authenticated (stderr): ${stderr.trim()}`);
    }

    if (!stdout.trim() && !stderr.trim()) {
      log("Authenticated, but CLI returned no identity output.");
    }
  });
}

// Run immediately
checkMoltbook();

// Run every 10 minutes
setInterval(checkMoltbook, 10 * 60 * 1000);
