# MVP Validation Techniques

## Pre-Build Validation

Test demand BEFORE writing code.

### Landing Page Test
1. Build a simple page describing what you'll build
2. Add email signup or waitlist
3. Drive traffic (ads, communities, cold outreach)
4. Measure: signups, click-through, time on page

**Threshold:** <50 signups in 2 weeks with effort = weak demand signal

### Fake Door Test
1. Add a button/link for the feature
2. When clicked, show "Coming soon, join waitlist"
3. Measure click rate vs signup rate

**Use for:** Testing if users WANT something, not just NEED something

### Wizard of Oz
1. Build the UI/interface
2. You manually do the work behind the scenes
3. User thinks it's automated

**Best for:** Testing UX and value prop before building backend

### Concierge MVP
1. Deliver the service manually to 5-10 users
2. No software, just you + spreadsheets + email
3. Learn the workflow before automating

**Best for:** Understanding the problem deeply before building

### Pre-Sell
1. Describe what you'll build
2. Ask for payment (refundable) before it exists
3. Money = real validation

**Threshold:** 10 paying customers before code = strong signal

---

## Post-Launch Signals

What to measure with <100 users.

### Primary Metrics

| Metric | What It Tells You | Target |
|--------|-------------------|--------|
| Activation rate | Did they experience core value? | >40% |
| Day 1 retention | Did they come back the next day? | >20% |
| Day 7 retention | Habit forming? | >10% |
| NPS / "Would recommend?" | Word of mouth potential | >30 |

### Secondary Metrics

| Metric | What It Tells You |
|--------|-------------------|
| Time to value | How long until "aha moment"? |
| Support requests | What's confusing? |
| Feature requests | What's missing? |
| Churn reasons | Why do they leave? |

### What NOT to Measure Yet

- Total signups (vanity)
- Page views (vanity)
- Social shares (vanity)
- Revenue (too early unless pre-sell)

---

## User Interview Script

### Opening (2 min)
- "Tell me about the last time you [problem context]"
- Listen for pain language

### Problem Exploration (5 min)
- "Walk me through what happened"
- "What was frustrating about that?"
- "How did you try to solve it?"
- "How often does this happen?"

### Solution Testing (5 min)
- Show MVP or describe concept
- "What do you think this does?"
- "Would this solve your problem?"
- "What's missing?"

### Closing (2 min)
- "Would you pay for this?" (watch body language)
- "Who else has this problem?"
- "Can I follow up when it's ready?"

### Red Flags in Interviews
- "That's interesting" (polite, not excited)
- "I might use it" (won't)
- "My friend would love this" (they wouldn't)

### Green Flags
- They describe the problem before you explain
- They've tried/paid for alternatives
- They ask when it's ready
- They offer to refer others

---

## Kill Criteria Framework

Define BEFORE building:

| Signal | Threshold | Action |
|--------|-----------|--------|
| Landing signups | <50 in 2 weeks | Pivot positioning or kill idea |
| Activation | <20% | Core value unclear, simplify |
| Day 7 retention | <10% | Problem not painful enough |
| Paid conversion | 0 in 50 trials | Value prop not compelling |
| User interviews | 8/10 "meh" reactions | Problem isn't real |

**The Rule:** If you hit the threshold, don't rationalize. Either pivot significantly or move on.

Most ideas fail. Finding out fast is the goal.
